/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.media.MediaClientTokenSupplier;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.media.impl.DefaultMediaApiClient;
import com.atlassian.migration.agent.media.impl.DefaultMediaFileUploader;
import com.atlassian.migration.agent.media.impl.MediaAuthInterceptor;
import com.atlassian.migration.agent.media.impl.RetryingMediaApiClient;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

@Singleton
public class DefaultMediaFileUploaderFactory
implements MediaFileUploaderFactory {
    private final MediaClientTokenSupplier mediaClientTokenSupplier;
    private final UserAgentInterceptor userAgentInterceptor;
    private final MigrationAgentConfiguration configuration;

    @Inject
    public DefaultMediaFileUploaderFactory(MediaClientTokenSupplier mediaClientTokenSupplier, MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor) {
        this.configuration = configuration;
        this.mediaClientTokenSupplier = mediaClientTokenSupplier;
        this.userAgentInterceptor = userAgentInterceptor;
    }

    @Override
    @Nonnull
    public MediaFileUploader create(String containerToken) {
        OkHttpClient httpClient = DefaultMediaFileUploaderFactory.buildMediaHttpClient(new MediaAuthInterceptor(() -> this.mediaClientTokenSupplier.getToken(containerToken)), this.userAgentInterceptor);
        HttpService httpService = new HttpService(() -> httpClient);
        return new DefaultMediaFileUploader(new RetryingMediaApiClient(new DefaultMediaApiClient(this.configuration, httpService)));
    }

    private static OkHttpClient buildMediaHttpClient(Interceptor ... interceptors) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).writeTimeout(3L, TimeUnit.MINUTES).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.MINUTES);
        Arrays.stream(interceptors).forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        return httpClientBuilder.build();
    }
}

