/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@Entity
@Table(name="MIG_WORK_ITEM")
public class WorkItem {
    @Column(name="refId", nullable=false, unique=true)
    private String refId;
    @Column(name="groupId", nullable=false)
    private String groupId;
    @Column(name="retryCount", nullable=false)
    private int retryCount;
    @Column(name="itemType", nullable=false)
    private String itemType;
    @Column(name="itemStatus", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Column(name="jobId")
    private String jobId;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="MIG_SEQUENCES")
    @Column(name="itemId", unique=true)
    private Long itemId;

    public Long getItemId() {
        return this.itemId;
    }

    private WorkItem() {
    }

    private WorkItem(String refId, String groupId, String itemType, Status status) {
        this.refId = refId;
        this.groupId = groupId;
        this.itemType = itemType;
        this.status = status;
    }

    public static WorkItem newReadyItem(String refId, String groupId, String itemType) {
        return new WorkItem(refId, groupId, itemType, Status.READY);
    }

    public String getRefId() {
        return this.refId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getItemType() {
        return this.itemType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static enum Status {
        READY,
        STARTED;

    }
}

