/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AppAssessmentProperty {
    MIGRATION_NOTES("migrationNotes"),
    MIGRATION_STATUS("migrationStatus"),
    ALTERNATIVE_APP_KEY("alternativeAppKey");

    private static final Map<String, AppAssessmentProperty> supportedProperties;
    private final String name;

    private AppAssessmentProperty(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isSupported(String propName) {
        return supportedProperties.containsKey(propName);
    }

    public static AppAssessmentProperty getAppAssessmentPropertyByName(String propName) {
        return supportedProperties.get(propName);
    }

    static {
        supportedProperties = ImmutableMap.copyOf(Arrays.stream(AppAssessmentProperty.values()).collect(Collectors.toMap(AppAssessmentProperty::getName, prop -> prop)));
    }
}

