/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.config;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
public class MigrationAgentConfiguration {
    public String getPluginKey() {
        return System.getProperty("migration.plugin.key", "com.atlassian.migration.agent");
    }

    public String getPluginVersion() {
        return System.getProperty("migration.plugin.version", "");
    }

    public boolean isFrontEndDevModeEnabled() {
        return Boolean.getBoolean("fe.dev.mode");
    }

    public String getMediaServiceUrl() {
        return System.getProperty("media.service.url", "https://api.media.atlassian.com");
    }

    public String getMigrationAppAggregatorUrl() {
        return System.getProperty("migration.aggregator.base.url", "https://api.atlassian.com/migration/aggregator");
    }

    public String getMigrationServiceBaseUrl() {
        return System.getProperty("migration.service.base.url", "https://api-private.atlassian.com/migration");
    }

    public String getUserMigrationServiceBaseUrl() {
        return System.getProperty("users.migration.service.base.url", "https://api-private.atlassian.com/migration/users");
    }

    public String getMigrationAnalyticsServiceBaseUrl() {
        return System.getProperty("migration.analytics.base.url", "https://api-private.atlassian.com/migration/analytics");
    }

    public String getAppMigrationServiceBaseUrl() {
        return System.getProperty("app.migration.service.base.url", "https://api.atlassian.com/app/migration");
    }

    public String getMigrationGatewayUrl() {
        return System.getProperty("migration.gateway.url", "https://migration.atlassian.com");
    }

    public boolean isBypassStargate() {
        return Boolean.getBoolean("stargate.service.bypass");
    }

    public boolean isSkipNonceCheck() {
        return Boolean.getBoolean("skip.nonce.check");
    }

    public int getAttachmentUploadBatchSize() {
        return Integer.getInteger("attachment.upload.batch.size", 20);
    }

    public int getAttachmentUploadConcurrency() {
        return Integer.getInteger("attachment.upload.concurrency", 5);
    }

    public int getAttachmentPrepareBatchSize() {
        return Integer.getInteger("attachment.prepare.batch.size", 1000);
    }

    public URI getMarketplaceBaseUrl() {
        return URI.create(System.getProperty("mpac.baseurl", "https://marketplace.atlassian.com"));
    }

    public boolean isDropDbOnStartEnabled() {
        return Stream.of(System.getenv("DROP_DB_ON_START"), System.getProperty("drop.db.on.start")).filter(Objects::nonNull).map(Boolean::valueOf).findFirst().orElse(false);
    }

    public int getAnalyticsSenderJobIntervalInSeconds() {
        return Integer.getInteger("migration.analytics.job.interval", 120);
    }

    public int getAnalyticsSenderBatchSize() {
        return Integer.getInteger("migration.analytics.batch.size", 200);
    }

    public int getAnalyticsSenderMaxWaitInMinutes() {
        return Integer.getInteger("migration.analytics.sender.max.wait", 45);
    }

    public int getLimitPerPageRequest() {
        return Integer.getInteger("app.usage.limit.per.page.request", 100);
    }

    public int getBatchSizePerQuery() {
        return Integer.getInteger("app.usage.batch.size.per.query", 999);
    }

    public boolean isAnalyticsSenderDisabled() {
        return Boolean.getBoolean("migration.analytics.sender.disabled");
    }

    public int getDetectedUserEmailAnalyticsEventUsersBatchSize() {
        return Integer.getInteger("migration.analytics.detected.email.users.batch.size", 100);
    }

    public Duration getIntervalBetweenDetectedUserEmailAnalyticsRuns() {
        long days = Long.getLong("migration.analytics.detected.email.interval.days", 5L);
        return Duration.ofDays(days);
    }
}

