/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration;

import com.atlassian.sal.api.features.DarkFeatureManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MigrationDarkFeaturesManager {
    private final DarkFeatureManager darkFeatureManager;

    @Inject
    public MigrationDarkFeaturesManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public boolean appMigrationEnabled() {
        return this.isFeatureEnabled("migration-assistant.app-migration.feature");
    }

    public boolean spaceExportInvalidEmailsCheckDisabled() {
        return this.isFeatureEnabled("migration-assistant.space-export-email-validation.disable");
    }

    public boolean invalidEmailsCheckDisabled() {
        return this.isFeatureEnabled("migration-assistant.disable.invalid-emails-check");
    }

    public boolean duplicateEmailsCheckDisabled() {
        return this.isFeatureEnabled("migration-assistant.disable.duplicate-emails-check");
    }

    public boolean appOutdatedCheckDisabled() {
        return this.isFeatureEnabled("migration-assistant.disable.app-outdated-check");
    }

    public boolean missingSpaceAttachmentsDisabled() {
        return this.isFeatureEnabled("migration-assistant.disable.missing-space-attachments");
    }

    private boolean isFeatureEnabled(String key) {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(key);
    }
}

