/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.Resources;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.ProductEntity;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.jpa.SessionFactorySupplier;
import com.atlassian.migration.agent.store.jpa.impl.DefaultClassLoaderService;
import com.atlassian.migration.agent.store.jpa.impl.ExcludingSchemaFilter;
import com.atlassian.migration.agent.store.jpa.impl.LiquibaseSchemaUpgrader;
import com.atlassian.migration.agent.store.jpa.impl.OracleDialect;
import com.atlassian.migration.agent.store.jpa.impl.ThreadBoundSessionContext;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaFilterProvider;
import org.slf4j.Logger;

@Singleton
public class DefaultSessionFactorySupplier
implements SessionFactorySupplier {
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultSessionFactorySupplier.class);
    private static final String JPA_ENTITIES_RESOURCE_PATH = "META-INF/jpa-entities";
    private static final String CHANGELOG_PATH = "META-INF/db-changelog/master.xml";
    private static final String ORACLE_DIALECT_PREFIX = "oracle";
    private final ConnectionProvider connectionProvider;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private Supplier<SessionFactory> sessionFactorySupplier;
    private final BootstrapManager bootstrapManager;

    @Inject
    DefaultSessionFactorySupplier(ConnectionProvider connectionProvider, MigrationAgentConfiguration migrationAgentConfiguration, BootstrapManager bootstrapManager) {
        this.connectionProvider = connectionProvider;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.bootstrapManager = bootstrapManager;
        this.sessionFactorySupplier = Lazy.supplier(this::buildSessionFactory);
    }

    @Override
    public SessionFactory get() {
        return (SessionFactory)this.sessionFactorySupplier.get();
    }

    private SessionFactory buildSessionFactory() {
        try {
            LiquibaseSchemaUpgrader.upgrade(this.connectionProvider.getConnection(), CHANGELOG_PATH);
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to get connection", (Throwable)e);
        }
        return this.buildMetadata(this.readEntityClassNames()).buildSessionFactory();
    }

    @VisibleForTesting
    List<String> readEntityClassNames() {
        try {
            return Resources.readLinesFromResources(JPA_ENTITIES_RESOURCE_PATH);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to load entity class names from META-INF/jpa-entities resource files", (Throwable)e);
        }
    }

    @VisibleForTesting
    Metadata buildMetadata(Collection<String> entityClassNames) {
        entityClassNames = this.sanitizeEntities(entityClassNames);
        DefaultClassLoaderService classLoaderService = new DefaultClassLoaderService();
        BootstrapServiceRegistry serviceRegistry = new BootstrapServiceRegistryBuilder().applyClassLoaderService((ClassLoaderService)new DefaultClassLoaderService()).build();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder(serviceRegistry);
        registryBuilder.applySetting("hibernate.connection.provider_class", (Object)this.connectionProvider);
        registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)this.getHbm2dllMode());
        registryBuilder.applySetting("hibernate.current_session_context_class", (Object)ThreadBoundSessionContext.class.getName());
        ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
        Optional<String> dialectName = Optional.ofNullable((String)applicationConfig.getProperty((Object)"hibernate.dialect"));
        if (dialectName.isPresent() && dialectName.get().toLowerCase().contains(ORACLE_DIALECT_PREFIX)) {
            registryBuilder.applySetting("hibernate.dialect", (Object)new OracleDialect());
        }
        HashSet<String> excludedSchemaUpdateTables = new HashSet<String>();
        for (String entityClassName : entityClassNames) {
            Class entityClass = classLoaderService.classForName(entityClassName);
            ProductEntity productEntity = entityClass.getAnnotation(ProductEntity.class);
            if (productEntity == null) continue;
            Table table = entityClass.getAnnotation(Table.class);
            String tableName = table == null ? entityClass.getSimpleName() : table.name();
            excludedSchemaUpdateTables.add(tableName);
        }
        if (!excludedSchemaUpdateTables.isEmpty()) {
            final ExcludingSchemaFilter schemaFilter = new ExcludingSchemaFilter(excludedSchemaUpdateTables);
            registryBuilder.applySetting("hibernate.hbm2ddl.schema_filter_provider", (Object)new SchemaFilterProvider(){

                public SchemaFilter getCreateFilter() {
                    return schemaFilter;
                }

                public SchemaFilter getDropFilter() {
                    return schemaFilter;
                }

                public SchemaFilter getMigrateFilter() {
                    return schemaFilter;
                }

                public SchemaFilter getValidateFilter() {
                    return schemaFilter;
                }
            });
        }
        MetadataSources sources = new MetadataSources((ServiceRegistry)registryBuilder.build());
        entityClassNames.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClassName(arg_0));
        return sources.getMetadataBuilder().build();
    }

    private List<String> sanitizeEntities(Collection<String> entityClassNames) {
        String poisonedEntityName = "com.atlassian.migration.agent.entity.RecentlyViewedEntity";
        return entityClassNames.stream().filter(className -> !poisonedEntityName.equals(className)).collect(Collectors.toList());
    }

    private Action getHbm2dllMode() {
        if (this.migrationAgentConfiguration.isDropDbOnStartEnabled()) {
            log.warn("Resetting DB model using Action.CREATE for HBM2DDL_AUTO");
            return Action.CREATE;
        }
        return Action.VALIDATE;
    }
}

