/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.atlassian.migration.agent.store.jpa.SessionFactorySupplier;
import com.atlassian.migration.agent.store.jpa.impl.DefaultQueryBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@ParametersAreNonnullByDefault
@Singleton
public class DefaultEntityManagerTemplate
implements EntityManagerTemplate {
    private final SessionFactorySupplier sessionFactorySupplier;

    @Inject
    public DefaultEntityManagerTemplate(SessionFactorySupplier sessionFactorySupplier) {
        this.sessionFactorySupplier = sessionFactorySupplier;
    }

    @Override
    public <T> T execute(Function<EntityManager, T> action) {
        Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
        return action.apply((EntityManager)session);
    }

    @Override
    public void execute(Consumer<EntityManager> action) {
        Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
        action.accept((EntityManager)session);
    }

    @Override
    @Nonnull
    public QueryBuilder<Void> query(String jpql) {
        return new DefaultQueryBuilder<Void>(this, em -> em.createQuery(jpql));
    }

    @Override
    @Nonnull
    public <T> QueryBuilder<T> query(Class<T> entityType, String jpql) {
        return new DefaultQueryBuilder(this, em -> em.createQuery(jpql, entityType));
    }

    @Override
    @Nonnull
    public <T> QueryBuilder<T> nativeQuery(Class<T> resultType, String sql) {
        return new DefaultQueryBuilder(this, em -> em.createNativeQuery(sql, resultType));
    }

    @Override
    @Nonnull
    public <T> QueryBuilder<T> namedQuery(Class<T> entityType, String queryName) {
        return new DefaultQueryBuilder(this, em -> em.createNamedQuery(queryName, entityType));
    }
}

