/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.LockModeType;

@Singleton
public class StepStoreImpl
implements StepStore {
    private final EntityManagerTemplate tmpl;

    @Inject
    StepStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Step getStep(String stepId) {
        return this.tmpl.query(Step.class, "select step from Step step where step.id=:stepId").param("stepId", (Object)stepId).single();
    }

    @Override
    public void addSteps(Collection<Step> steps) {
        steps.forEach(this.tmpl::persist);
        this.tmpl.flush();
    }

    @Override
    public void update(Step step) {
        this.tmpl.merge(step);
    }

    @Override
    public Step getAndLock(String stepId) {
        return this.tmpl.query(Step.class, "select step from Step step where step.id=:stepId").param("stepId", (Object)stepId).lock(LockModeType.PESSIMISTIC_WRITE).single();
    }
}

