/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.migration.agent.okhttp.ErrorResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsersMigrationStatusResponse {
    @JsonProperty
    private final String taskId;
    @JsonProperty
    private final int percentageComplete;
    @JsonProperty
    private final boolean complete;
    @JsonProperty
    private final List<ErrorResponse> errors;

    @JsonCreator
    public UsersMigrationStatusResponse(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="percentageComplete") int percentageComplete, @JsonProperty(value="complete") boolean complete, @JsonProperty(value="errors") List<ErrorResponse> errors) {
        this.taskId = Objects.requireNonNull(taskId);
        this.percentageComplete = percentageComplete;
        this.complete = complete;
        this.errors = errors;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getPercentageComplete() {
        return this.percentageComplete;
    }

    public boolean isSuccessful() {
        return this.complete && this.errors.isEmpty();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Optional<String> getFirstErrorMessage() {
        if (this.errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.errors.get((int)0).message);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }
}

