/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

class AttachmentsUploadTracker {
    private final AtomicLong numOfUploadedAttachments = new AtomicLong();
    private final AtomicLong uploadedBytes = new AtomicLong();
    private final long numOfAttachments;
    private final long totalSizeToUpload;
    private final long totalSize;
    private final Consumer<UploadState> onProgress;

    AttachmentsUploadTracker(long numOfAttachments, long totalSize, long totalSizeToUpload, Consumer<UploadState> onProgress) {
        this.numOfAttachments = numOfAttachments;
        this.totalSize = totalSize;
        this.onProgress = onProgress;
        this.totalSizeToUpload = totalSizeToUpload;
    }

    UploadState getUploadState() {
        return new UploadState(this.numOfUploadedAttachments.get(), this.numOfAttachments, this.uploadedBytes.get(), this.totalSize, this.totalSizeToUpload);
    }

    void addUploadedBytes(long uploadedBytes) {
        this.uploadedBytes.addAndGet(uploadedBytes);
        this.onProgress.accept(this.getUploadState());
    }

    void attachmentUploaded() {
        this.numOfUploadedAttachments.incrementAndGet();
        this.onProgress.accept(this.getUploadState());
    }

    static class UploadState {
        final long numOfAttachments;
        final long numOfUploadedAttachments;
        final long uploadedBytes;
        final int percentOfProgress;
        final long totalBytes;

        UploadState(long numOfUploadedAttachments, long numOfAttachments, long uploadedBytes, long totalBytes, long totalBytesToUpload) {
            this.numOfUploadedAttachments = numOfUploadedAttachments;
            this.numOfAttachments = numOfAttachments;
            this.uploadedBytes = uploadedBytes;
            this.totalBytes = totalBytes;
            this.percentOfProgress = totalBytesToUpload == 0L ? 100 : (int)Math.min(this.uploadedBytes * 100L / totalBytesToUpload, 100L);
        }
    }
}

