/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrator;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsUploadTracker;
import com.atlassian.migration.agent.store.AttachmentMigrationCandidate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;

class AttachmentsToMigrateConsumer
implements Runnable {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentsToMigrateConsumer.class);
    private final BlockingQueue<AttachmentMigrationCandidate> buffer;
    private final CloudSite cloudSite;
    private final AttachmentMigrator attachmentMigrator;
    private final AttachmentsUploadTracker progressTracker;
    private final BooleanSupplier allAttachmentsProduced;
    private final BooleanSupplier forceStop;

    AttachmentsToMigrateConsumer(CloudSite cloudSite, BlockingQueue<AttachmentMigrationCandidate> buffer, AttachmentMigrator attachmentMigrator, AttachmentsUploadTracker progressTracker, BooleanSupplier allAttachmentsProduced, BooleanSupplier forceStop) {
        this.buffer = buffer;
        this.cloudSite = cloudSite;
        this.attachmentMigrator = attachmentMigrator;
        this.progressTracker = progressTracker;
        this.allAttachmentsProduced = allAttachmentsProduced;
        this.forceStop = forceStop;
    }

    @Override
    public void run() {
        block5: {
            while (true) {
                AttachmentMigrationCandidate attachmentCandidate;
                if (this.forceStop.getAsBoolean()) {
                    log.info("Stop requested. Will exit...");
                    break block5;
                }
                try {
                    attachmentCandidate = this.buffer.poll(200L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new StepExecutionException("Failed to poll attachment from buffer", ex);
                }
                if (attachmentCandidate != null) {
                    if (!this.attachmentMigrator.migrate(attachmentCandidate, this.cloudSite, this.progressTracker::addUploadedBytes)) continue;
                    this.progressTracker.attachmentUploaded();
                    continue;
                }
                if (this.allAttachmentsProduced.getAsBoolean()) break;
            }
            log.info("No more attachments to upload. Will exit...");
        }
    }
}

