/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.fugue.Pair;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.LoggingContextProvider;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.planning.StepCoordinator;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepSchedulerService {
    private static final Logger log = ContextLoggerFactory.getLogger(StepSchedulerService.class);
    private LoggingContextProvider loggingContextProvider;
    private PluginTransactionTemplate ptx;
    private SchedulerService schedulerService;
    private ProgressTracker progressTracker;
    private StepCoordinator stepCoordinator;
    private StepStore stepStore;

    @Autowired
    public StepSchedulerService(LoggingContextProvider loggingContextProvider, PluginTransactionTemplate ptx, SchedulerService schedulerService, ProgressTracker progressTracker, StepCoordinator stepCoordinator, StepStore stepStore) {
        this.loggingContextProvider = loggingContextProvider;
        this.ptx = ptx;
        this.schedulerService = schedulerService;
        this.stepStore = stepStore;
        this.progressTracker = progressTracker;
        this.stepCoordinator = stepCoordinator;
    }

    public void consumeStep(String stepId, StepType stepType, Supplier<Optional<StepResult>> stepConsumer) {
        try {
            Pair stepAndPlanStatus = this.ptx.read(() -> {
                Step step = this.stepStore.getStep(stepId);
                return Pair.pair((Object)((Object)step.getProgress().getStatus()), (Object)((Object)step.getPlan().getProgress().getStatus()));
            });
            ExecutionStatus stepStatus = (ExecutionStatus)((Object)stepAndPlanStatus.left());
            ExecutionStatus planStatus = (ExecutionStatus)((Object)stepAndPlanStatus.right());
            if (stepStatus != ExecutionStatus.CREATED) {
                log.error("The same step was received twice. The step will be completed (if required), and removed from the queue.");
                if (!stepStatus.isCompleted()) {
                    this.progressTracker.completed(stepId, StepResult.failed("Step failed with an unknown reason."));
                }
                this.stepCoordinator.completeStep(stepId);
                return;
            }
            if (planStatus == ExecutionStatus.STOPPING) {
                this.progressTracker.completed(stepId, StepResult.stopped());
                this.stepCoordinator.completeStep(stepId);
                return;
            }
            this.progressTracker.started(stepId, stepType.getDisplayName());
            this.runStep(stepId, stepType, stepConsumer, null);
        }
        catch (Exception e) {
            log.error("Failed to start step with ID: {}. Message: {}", new Object[]{stepId, e.getMessage(), e});
            this.handleError(e, stepId, stepType);
        }
    }

    public void scheduleStepOnce(String stepId, JobRunnerKey jobRunnerKey, JobId jobId, StepType stepType, Map<String, Serializable> jobParams) {
        this.scheduleStep(stepId, jobRunnerKey, jobId, stepType, jobParams, Schedule.runOnce((Date)new Date(System.currentTimeMillis() + 5000L)));
    }

    public void scheduleStep(String stepId, JobRunnerKey jobRunnerKey, JobId jobId, StepType stepType, Map<String, Serializable> jobParams, Schedule schedule) {
        try {
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(jobParams).withSchedule(schedule);
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (Exception e) {
            log.error("Failed to schedule job with ID: {}. Message: {}", new Object[]{jobId, e.getMessage(), e});
            this.handleError(e, stepId, stepType);
        }
    }

    public void runStep(String stepId, StepType stepType, Supplier<StepResult> stepExecutor) {
        this.runStep(stepId, stepType, () -> Optional.of(stepExecutor.get()), null);
    }

    public void runScheduledStep(JobId jobId, StepType stepType, String stepId, Supplier<Optional<StepResult>> stepExecutor) {
        this.runStep(stepId, stepType, stepExecutor, () -> this.schedulerService.unscheduleJob(jobId));
    }

    private void runStep(String stepId, StepType stepType, Supplier<Optional<StepResult>> stepExecutor, @Nullable Runnable onCompletion) {
        this.loggingContextProvider.forStep(stepId).execute(() -> {
            try {
                ((Optional)stepExecutor.get()).ifPresent(result -> {
                    this.progressTracker.completed(stepId, (StepResult)result);
                    this.stepCoordinator.completeStep(stepId);
                    if (onCompletion != null) {
                        onCompletion.run();
                    }
                });
            }
            catch (Exception e) {
                try {
                    if (onCompletion != null) {
                        onCompletion.run();
                    }
                }
                catch (RuntimeException e2) {
                    log.error("An error occurred while trying to complete step", (Throwable)e2);
                }
                this.handleError(e, stepId, stepType);
            }
        });
    }

    private void handleError(Exception e, String stepId, StepType stepType) {
        this.tryToComplete(stepId, StepResult.failed(String.format("An unexpected error occurred during step: %s. Error: %s", stepType.getDisplayName(), e.getMessage()), e));
        this.stepCoordinator.completeStep(stepId);
    }

    private void tryToComplete(String stepId, StepResult result) {
        try {
            this.progressTracker.completed(stepId, result);
        }
        catch (IllegalStateException e) {
            log.error("Tried to make an illegal status transition between step statuses for step {}", (Object)stepId, (Object)e);
        }
    }
}

