/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.LoggingContextProvider;
import com.atlassian.migration.agent.service.impl.WorkItemQueue;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class StepCoordinator {
    private static final Logger log = ContextLoggerFactory.getLogger(StepSchedulerService.class);
    private final Map<Class<?>, StepPlanningEngine> stepPlanningEngines;
    private final TaskPlanningEngine taskPlanningEngine;
    private final LoggingContextProvider loggingContextProvider;
    private final PluginTransactionTemplate ptx;
    private final WorkItemQueue queue;
    private final StepStore stepStore;
    private final TaskStore taskStore;
    private final ProgressTracker progressTracker;

    @Inject
    StepCoordinator(List<StepPlanningEngine> stepPlanningEngines, TaskPlanningEngine taskPlanningEngine, LoggingContextProvider loggingContextProvider, PluginTransactionTemplate ptx, WorkItemQueue queue, StepStore stepStore, TaskStore taskStore, ProgressTracker progressTracker) {
        this.stepPlanningEngines = stepPlanningEngines.stream().collect(Collectors.toMap(StepPlanningEngine::getTaskType, Function.identity()));
        this.taskPlanningEngine = taskPlanningEngine;
        this.loggingContextProvider = loggingContextProvider;
        this.ptx = ptx;
        this.queue = queue;
        this.stepStore = stepStore;
        this.taskStore = taskStore;
        this.progressTracker = progressTracker;
    }

    public void schedulePlan(String planId) {
        this.taskPlanningEngine.getFirstTasks(planId).forEach(task -> this.planTask((Task)task, planId));
    }

    public void cancelAndStopReadySteps(String planId) {
        this.queue.dequeueReadyItemsInGroup(planId).forEach(workItem -> this.progressTracker.completed(workItem.getRefId(), StepResult.stopped()));
    }

    public void completeStep(String currentStepId) {
        this.loggingContextProvider.forStep(currentStepId).execute(() -> this.ptx.write(() -> {
            boolean isQueueEmpty;
            this.queue.dequeue(currentStepId);
            Step currentStep = this.stepStore.getStep(currentStepId);
            if (!currentStep.getProgress().getStatus().isCompleted()) {
                log.error("Received a request to completeStep an incomplete step. Status is {}, but should be one of {}.", (Object)currentStep.getProgress().getStatus(), ExecutionStatus.COMPLETE_STATUSES);
                return;
            }
            Plan plan = currentStep.getPlan();
            String planId = plan.getId();
            boolean bl = isQueueEmpty = !this.queue.hasItemsInGroup(planId);
            if (isQueueEmpty) {
                if (plan.getProgress().getStatus() == ExecutionStatus.STOPPING) {
                    this.progressTracker.stopPlan(planId);
                    return;
                }
                if (currentStep.getProgress().getStatus() == ExecutionStatus.FAILED) {
                    this.progressTracker.failPlan(planId, currentStep.getProgress().getMessage());
                    return;
                }
            }
            if (currentStep.getProgress().getStatus().isUnsuccessful()) {
                return;
            }
            Task task = currentStep.getTask();
            Optional<Step> maybeNextStep = this.getStepPlanningEngine(task).createNextStep(task, currentStep);
            if (maybeNextStep.isPresent()) {
                Step step = maybeNextStep.get();
                step.setIndex(currentStep.getIndex() + 1);
                step.setTask(task);
                this.queueStep(step, planId);
            } else {
                boolean newTasks = this.completeTask(task, planId);
                if (isQueueEmpty && !newTasks) {
                    this.completePlan(planId);
                }
            }
        }));
    }

    private void completePlan(String planId) {
        Optional<Task> failedTask = this.taskStore.findFirstTaskWithStatusForPlan(planId, ExecutionStatus.FAILED);
        if (failedTask.isPresent()) {
            this.progressTracker.failPlan(planId, failedTask.get().getProgress().getMessage());
        } else {
            this.progressTracker.succeedPlan(planId);
        }
    }

    private boolean completeTask(Task task, String planId) {
        List<Task> newTasks = this.taskPlanningEngine.getNextTasks(task);
        newTasks.forEach(nextTask -> this.planTask((Task)nextTask, planId));
        return !newTasks.isEmpty();
    }

    private void queueStep(Step step, String planId) {
        this.stepStore.addSteps((Collection<Step>)ImmutableList.of((Object)step));
        this.queue.enqueue(step.getId(), planId, step.getType());
    }

    private void planTask(Task task, String planId) {
        Step step = this.getStepPlanningEngine(task).createFirstStep(task);
        step.setIndex(0);
        step.setTask(task);
        this.queueStep(step, planId);
    }

    private StepPlanningEngine getStepPlanningEngine(Task task) {
        return this.stepPlanningEngines.get(task.getClass());
    }
}

