/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
public class MigrationAppAggregatorService {
    private static final String CACHE_NAME = "migrationAppAggregatorCache";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final RetryPolicy retryPolicy;
    private final Cache<String, MigrationAppAggregatorResponse> maaCache;
    private static final Logger LOG = LoggerFactory.getLogger(MigrationAppAggregatorService.class);

    @Inject
    public MigrationAppAggregatorService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CacheManager cacheManager) {
        this(new HttpService(() -> MigrationAppAggregatorService.buildHttpClient(userAgentInterceptor)), configuration, cacheManager, RetryPolicyBuilder.defaultPolicy().build());
    }

    @VisibleForTesting
    MigrationAppAggregatorService(HttpService httpService, MigrationAgentConfiguration configuration, CacheManager cacheManager, RetryPolicy retryPolicy) {
        this.maaCache = cacheManager.getCache(CACHE_NAME, (CacheLoader)new AppAggregatorCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(55L, TimeUnit.MINUTES).build());
        this.httpService = httpService;
        this.configuration = configuration;
        this.retryPolicy = retryPolicy;
        this.maaCache.removeAll();
    }

    @VisibleForTesting
    public MigrationAppAggregatorService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, MemoryCacheManager cacheManager, RetryPolicy retryPolicy) {
        this(new HttpService(() -> MigrationAppAggregatorService.buildHttpClient(userAgentInterceptor)), configuration, (CacheManager)cacheManager, retryPolicy);
    }

    public MigrationAppAggregatorResponse getCachedAppData(String pluginKey) {
        return (MigrationAppAggregatorResponse)this.maaCache.get((Object)pluginKey);
    }

    private MigrationAppAggregatorResponse getAggregatedAppData(String pluginKey) {
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/" + pluginKey).query("application=confluence").toUriString()).get().build();
            return this.callJsonWithRetries(request, new TypeReference<MigrationAppAggregatorResponse>(){});
        }
        catch (HttpServiceException e) {
            LOG.warn("Failed to talk to app-aggregator. Returning default values. Error code: {}", (Object)e.getStatusCode());
            return MigrationAppAggregatorResponse.empty(e.getStatusCode());
        }
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callJson(request, bodyType));
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationAppAggregatorUrl());
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private class AppAggregatorCacheLoader
    implements CacheLoader<String, MigrationAppAggregatorResponse> {
        private AppAggregatorCacheLoader() {
        }

        @Nonnull
        public MigrationAppAggregatorResponse load(@Nonnull String key) {
            return MigrationAppAggregatorService.this.getAggregatedAppData(key);
        }
    }
}

