/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.SpaceAttachments;
import com.atlassian.migration.agent.store.AttachmentMigrationCandidate;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.Page;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultAttachmentService
implements AttachmentService {
    private final PluginTransactionTemplate ptx;
    private final AttachmentMigrationStore attachmentMigrationStore;
    private final AttachmentStore attachmentStore;
    private final AttachmentManager attachmentManager;
    private final TransactionTemplate tx;
    private final MigrationAgentConfiguration migrationAgentConfiguration;

    @Inject
    public DefaultAttachmentService(PluginTransactionTemplate ptx, AttachmentMigrationStore attachmentMigrationStore, AttachmentStore attachmentStore, AttachmentManager attachmentManager, TransactionTemplate tx, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.ptx = ptx;
        this.attachmentMigrationStore = attachmentMigrationStore;
        this.attachmentStore = attachmentStore;
        this.attachmentManager = attachmentManager;
        this.tx = tx;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    @Override
    public SpaceAttachments getAttachmentsToMigrate(String spaceKey, CloudSite cloudSite, int batchSize) {
        String cloudId = cloudSite.getCloudId();
        long attachmentsSizeToUpload = this.getAttachmentsToMigrateSize(spaceKey);
        return new SpaceAttachments(this.listAttachmentsToMigrate(cloudId, spaceKey, batchSize), attachmentsSizeToUpload);
    }

    @Override
    public void logSuccessfulAttachmentMigration(CloudSite cloudSite, com.atlassian.migration.agent.entity.Attachment attachment, String mediaId) {
        this.ptx.write(() -> {
            AttachmentMigration attachmentMigration = new AttachmentMigration();
            attachmentMigration.setCloudId(cloudSite.getCloudId());
            attachmentMigration.setAttachmentId(attachment.getId());
            attachmentMigration.setMediaId(mediaId);
            attachmentMigration.setVersion(attachment.getVersion());
            this.attachmentMigrationStore.saveMigration(attachmentMigration);
        });
    }

    @Override
    public void logFailedAttachmentMigration(CloudSite cloudSite, com.atlassian.migration.agent.entity.Attachment attachment) {
        this.ptx.write(() -> {
            AttachmentMigration attachmentMigration = new AttachmentMigration();
            attachmentMigration.setCloudId(cloudSite.getCloudId());
            attachmentMigration.setAttachmentId(attachment.getId());
            attachmentMigration.setMediaId(null);
            attachmentMigration.setVersion(attachment.getVersion());
            this.attachmentMigrationStore.saveMigration(attachmentMigration);
        });
    }

    @Override
    public int deleteAttachmentMigrationTrackingByCloudSite(CloudSite cloudSite) {
        return this.ptx.write(() -> this.attachmentMigrationStore.deleteMigrationsByCloudId(cloudSite.getCloudId()));
    }

    @Override
    public void prepareMigratedAttachmentsForExport(String spaceKey, String cloudId) {
        this.paginateOverMigratedAttachments(spaceKey, cloudId, this.migrationAgentConfiguration.getAttachmentPrepareBatchSize(), (attachment, migData) -> attachment.setFileStoreId(migData.getMediaId()));
    }

    @Override
    public void cleanMigratedAttachmentsAfterExport(String spaceKey, String cloudId) {
        this.paginateOverMigratedAttachments(spaceKey, cloudId, this.migrationAgentConfiguration.getAttachmentPrepareBatchSize(), (attachment, migData) -> attachment.getProperties().removeProperty("FILESTORE_ID"));
    }

    private void paginateOverMigratedAttachments(String spaceKey, String cloudId, int pageSize, BiConsumer<Attachment, AttachmentMigration> attachmentConsumer) {
        this.tx.execute(() -> {
            this.ptx.write(() -> {
                Page<AttachmentMigration> page = this.attachmentMigrationStore.listMigrations(cloudId, spaceKey, pageSize);
                while (page.hasContent()) {
                    Map migDataByAttachmentId = page.getContent().stream().collect(Collectors.toMap(AttachmentMigration::getAttachmentId, Function.identity()));
                    this.attachmentManager.getAttachments((List)ImmutableList.copyOf(migDataByAttachmentId.keySet())).forEach(attachment -> attachmentConsumer.accept((Attachment)attachment, (AttachmentMigration)migDataByAttachmentId.get(attachment.getId())));
                    page = page.next();
                }
            });
            return true;
        });
    }

    private Page<AttachmentMigrationCandidate> listAttachmentsToMigrate(String cloudId, String spaceKey, int limit) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrate(cloudId, spaceKey, limit));
    }

    private long getAttachmentsToMigrateSize(String spaceKey) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrateSize(spaceKey));
    }
}

