/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.cloud;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.cloud.NonceService;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.net.URI;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

@Singleton
@ParametersAreNonnullByDefault
public class CloudSiteSetupService {
    private final NonceService nonceService;
    private final SENSupplier senSupplier;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final ApplicationProperties applicationProperties;
    private final LegalService legalService;
    private final AnalyticsConfigService analyticsConfigService;

    @Inject
    CloudSiteSetupService(NonceService nonceService, SENSupplier senSupplier, MigrationAgentConfiguration migrationAgentConfiguration, ApplicationProperties applicationProperties, LegalService legalService, AnalyticsConfigService analyticsConfigService) {
        this.nonceService = nonceService;
        this.senSupplier = senSupplier;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.applicationProperties = applicationProperties;
        this.legalService = legalService;
        this.analyticsConfigService = analyticsConfigService;
    }

    public String generateCloudSiteSetupUrl(URI returnUrl) {
        String sen;
        String mgBaseUrl = this.migrationAgentConfiguration.getMigrationGatewayUrl();
        UriBuilder setupUrlBuilder = UriBuilder.fromUri((String)mgBaseUrl).path("setup").queryParam("back", new Object[]{returnUrl});
        String nonce = this.nonceService.generateAndSaveNonce();
        URI continueUrl = UriBuilder.fromUri((String)this.applicationProperties.getBaseUrl(UrlMode.CANONICAL)).path("admin/save-cloud-site.action").queryParam("nonce", new Object[]{nonce}).build(new Object[0]);
        setupUrlBuilder.queryParam("continue", new Object[]{continueUrl});
        if ((this.legalService.getRememberLegalOptIn() || this.analyticsConfigService.canCollectAnalytics()) && StringUtils.isNotEmpty((CharSequence)(sen = this.senSupplier.get()))) {
            setupUrlBuilder.queryParam("sen", new Object[]{sen});
        }
        return setupUrlBuilder.build(new Object[0]).toASCIIString();
    }
}

