/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.cloud;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.CloudSiteStore;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class CloudSiteService {
    private final PluginTransactionTemplate ptx;
    private final CloudSiteStore cloudSiteStore;
    private final AttachmentMigrationStore attachmentMigrationStore;
    private final PlanStore planStore;

    @Inject
    public CloudSiteService(PluginTransactionTemplate ptx, CloudSiteStore cloudSiteStore, AttachmentMigrationStore attachmentMigrationStore, PlanStore planStore) {
        this.ptx = ptx;
        this.cloudSiteStore = cloudSiteStore;
        this.attachmentMigrationStore = attachmentMigrationStore;
        this.planStore = planStore;
    }

    @Nonnull
    public List<CloudSite> getAllSites() {
        return this.ptx.read(this.cloudSiteStore::getAllSites);
    }

    public Optional<CloudSite> getByCloudId(String cloudId) {
        return this.ptx.read(() -> this.cloudSiteStore.getByCloudId(cloudId));
    }

    public CloudSite getByStepId(String stepId) {
        return this.ptx.read(() -> this.cloudSiteStore.getByStepId(stepId));
    }

    public Optional<String> getNonFailingToken() {
        return this.ptx.read(this.cloudSiteStore::getNonFailingToken);
    }

    public void markTokenAsFailed(String token) {
        this.ptx.write(() -> this.cloudSiteStore.markTokenAsFailed(token));
    }

    public CloudSite createOrUpdate(String cloudId, String cloudUrl, String containerToken, Optional<Edition> maybeEdition) {
        Optional<CloudEdition> maybeCloudEdition = maybeEdition.map(CloudEdition::from);
        Optional maybeCloudSite = this.ptx.read(() -> this.cloudSiteStore.getByCloudUrl(cloudUrl));
        if (!maybeCloudSite.isPresent()) {
            return this.ptx.write(() -> this.cloudSiteStore.create(new CloudSite(cloudId, cloudUrl, containerToken).withEdition(maybeCloudEdition)));
        }
        CloudSite oldCloudSite = (CloudSite)maybeCloudSite.get();
        if (!cloudId.equals(oldCloudSite.getCloudId())) {
            this.ptx.write(() -> {
                String tempCloudURL = UUID.randomUUID().toString();
                oldCloudSite.setCloudUrl(tempCloudURL);
                this.cloudSiteStore.update(oldCloudSite);
            });
            return this.ptx.write(() -> {
                CloudSite newCloudSite = this.cloudSiteStore.create(new CloudSite(cloudId, cloudUrl, containerToken).withEdition(maybeCloudEdition));
                List<Plan> plans = this.planStore.getAllPlansByCloudId(oldCloudSite.getCloudId());
                plans.forEach(plan -> {
                    plan.setCloudSite(newCloudSite);
                    this.planStore.updatePlan((Plan)plan);
                });
                this.attachmentMigrationStore.deleteMigrationsByCloudId(oldCloudSite.getCloudId());
                this.cloudSiteStore.removeSiteByCloudId(oldCloudSite.getCloudId());
                return newCloudSite;
            });
        }
        return this.ptx.write(() -> {
            if (!containerToken.equals(oldCloudSite.getContainerToken())) {
                oldCloudSite.setContainerToken(containerToken);
                oldCloudSite.setFailing(false);
            }
            return this.cloudSiteStore.update(oldCloudSite.withEdition(maybeCloudEdition));
        });
    }

    public CloudSite updateMediaClientId(String cloudId, String mediaClientId) {
        return this.ptx.write(() -> {
            Optional<CloudSite> maybeCloudSite = this.cloudSiteStore.getByCloudId(cloudId);
            CloudSite cloudSite = maybeCloudSite.orElseThrow(() -> new IllegalStateException(String.format("Failed to find cloud site record for cloudId = %s", cloudId)));
            cloudSite.setMediaClientId(mediaClientId);
            return this.cloudSiteStore.update(cloudSite);
        });
    }

    public CloudSite updateCloudEdition(String cloudId, CloudEdition cloudEdition) {
        return this.ptx.write(() -> {
            Optional<CloudSite> maybeCloudSite = this.cloudSiteStore.getByCloudId(cloudId);
            CloudSite cloudSite = maybeCloudSite.orElseThrow(() -> new IllegalStateException(String.format("Failed to find cloud site record for cloudId = %s", cloudId)));
            cloudSite.setEdition(cloudEdition);
            return this.cloudSiteStore.update(cloudSite);
        });
    }
}

