/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.space;

import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.space.SpaceConflictContext;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class SpaceConflictCheckContextProvider
implements CheckContextProvider<SpaceConflictContext> {
    private static final String CLOUD_ID_KEY = "cloudId";
    private static final String SPACE_KEYS_KEY = "spaceKeys";

    @Override
    public SpaceConflictContext apply(Map<String, Object> parameters) {
        String cloudId = (String)parameters.get(CLOUD_ID_KEY);
        String commaSeparatedSpaceKeys = (String)parameters.get(SPACE_KEYS_KEY);
        if (cloudId == null) {
            throw new IllegalArgumentException("cloudId not found in the parameters");
        }
        if (commaSeparatedSpaceKeys == null) {
            throw new IllegalArgumentException("space keys not found in the parameters");
        }
        Object[] keys = commaSeparatedSpaceKeys.split(",");
        HashSet spaceKeys = Sets.newHashSet((Object[])keys);
        return new SpaceConflictContext(cloudId, spaceKeys);
    }
}

