/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.free;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictChecker;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class CloudFreeUsersConflictMapper
extends AbstractMapper {
    private static final String EDITION_CHANGED_KEY = "editionChanged";

    public void inject(CheckResultDto dto, CheckResult checkResult) {
        switch (dto.getStatus()) {
            case RUNNING: {
                dto.setDescription("Checking for plan limits");
                return;
            }
            case EXECUTION_ERROR: {
                dto.setDescription("We couldn\u2019t check for users count limit");
                return;
            }
            case SUCCESS: {
                dto.setDescription("Cloud plan has been upgraded");
                CheckDetailsDto details = new CheckDetailsDto();
                details.setInfo((Map)ImmutableMap.of((Object)EDITION_CHANGED_KEY, (Object)CloudFreeUsersConflictChecker.hasEditionChanged(checkResult.details)));
                dto.setDetails(details);
                return;
            }
        }
        CheckDetailsDto details = new CheckDetailsDto();
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("cloudFreeUsersLimit", CloudFreeUsersConflictChecker.retrieveUsersLimit(checkResult.details));
        info.put("links", CloudFreeUsersConflictChecker.retrieveLinks(checkResult.details));
        details.setInfo(info);
        dto.setDetails(details);
        dto.setStatus(CloudFreeUsersConflictChecker.retrieveStatus(checkResult.details));
        if (dto.getStatus() == Status.ERROR) {
            dto.setDescription("User limit exceeded");
        } else if (dto.getStatus() == Status.WARNING) {
            dto.setDescription("You may exceed your user limit");
        }
    }

    public static boolean hasEditionChanged(CheckResultDto dto) {
        CheckDetailsDto details = dto.getDetails();
        if (details == null) {
            return false;
        }
        Map info = details.getInfo();
        if (info == null) {
            return false;
        }
        return info.getOrDefault(EDITION_CHANGED_KEY, false);
    }
}

