/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.free;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictContext;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.user.CloudEditionCheckResponse;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationRequest;
import com.atlassian.migration.agent.service.user.UsersMigrationRequestBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

public class CloudFreeUsersConflictChecker
implements Checker<CloudFreeUsersConflictContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(CloudFreeUsersConflictChecker.class);
    private static final int ERROR_CODE = 100;
    private static final int CLOUD_ERROR_CODE = 200;
    private static final String LINKS_KEY = "links";
    private static final String USERS_LIMIT_KEY = "usersLimit";
    private static final String STATUS_KEY = "status";
    private static final String CLOUD_PLANS_KEY = "cloudPlans";
    private static final String USERS_MGT_CLOUD_KEY = "usersManagementInCloud";
    private static final String CLOUD_UPGRADE_KEY = "cloudPlanUpgrade";
    private static final String USERS_MGT_SERVER_KEY = "usersManagementInServer";
    private static final String ADMIN_ATLASSIAN_PROD_URL = "https://admin.atlassian.com/s/";
    private static final String ADMIN_ATLASSIAN_STAGING_URL = "https://admin.stg.atlassian.com/s/";
    private static final String USERS_PAGE_PATH = "/admin/users/showallusers.action";
    @VisibleForTesting
    public static final String EDITION_CHANGED = "editionChanged";
    private final CloudSiteService cloudSiteService;
    private final RetryingUsersMigrationService usersMigrationService;
    private final UsersMigrationRequestBuilder usersMigrationRequestBuilder;
    private final String serverBaseUrl;

    CloudFreeUsersConflictChecker(CloudSiteService cloudSiteService, RetryingUsersMigrationService usersMigrationService, UsersMigrationRequestBuilder usersMigrationRequestBuilder, SystemInformationService systemInformationService) {
        this.cloudSiteService = cloudSiteService;
        this.usersMigrationService = usersMigrationService;
        this.usersMigrationRequestBuilder = usersMigrationRequestBuilder;
        this.serverBaseUrl = systemInformationService.getConfluenceInfo().getBaseUrl();
    }

    public CheckResult check(CloudFreeUsersConflictContext ctx) {
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(ctx.cloudId);
        if (!cloudSite.isPresent()) {
            log.error("Cannot find CloudSite using cloudId: {}.", (Object)ctx.cloudId);
            return Checker.buildCheckResultWithExecutionError((int)200);
        }
        CloudSite cloudSiteEntity = cloudSite.get();
        String containerToken = cloudSiteEntity.getContainerToken();
        CloudEdition currentCloudEdition = cloudSiteEntity.getEdition();
        try {
            UsersMigrationRequest request = this.usersMigrationRequestBuilder.createUsersMigrationRequest();
            CloudEditionCheckResponse response = this.usersMigrationService.getCloudEditionCheck(containerToken, request);
            CloudEdition actualCloudEdition = CloudEdition.from(response.edition);
            boolean editionChanged = false;
            if (actualCloudEdition != currentCloudEdition) {
                this.cloudSiteService.updateCloudEdition(ctx.cloudId, actualCloudEdition);
                editionChanged = true;
            }
            if (actualCloudEdition != CloudEdition.FREE) {
                return new CheckResult(true, (Map)ImmutableMap.of((Object)EDITION_CHANGED, (Object)editionChanged));
            }
            return new CheckResult(false, this.createResultDetails(ctx.cloudId, cloudSiteEntity.getCloudUrl(), request, response));
        }
        catch (RuntimeException e) {
            log.error("Error executing cloud free users conflict check.", (Throwable)e);
            return Checker.buildCheckResultWithExecutionError((int)100);
        }
    }

    private Map<String, Object> createResultDetails(String cloudId, String cloudUrl, UsersMigrationRequest request, CloudEditionCheckResponse response) {
        String cloudUrlPath = CloudFreeUsersConflictChecker.isCloudUrlInProduction(cloudUrl) ? ADMIN_ATLASSIAN_PROD_URL : ADMIN_ATLASSIAN_STAGING_URL;
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put(USERS_LIMIT_KEY, response.usersCount);
        details.put(STATUS_KEY, this.getStatusByUsersCount(request, response));
        details.put(LINKS_KEY, ImmutableMap.of((Object)CLOUD_PLANS_KEY, (Object)"https://confluence.atlassian.com/confcloud/confluence-cloud-plans-972334171.html", (Object)USERS_MGT_CLOUD_KEY, (Object)UriComponentsBuilder.fromHttpUrl((String)cloudUrlPath).path(cloudId).path("/users").toUriString(), (Object)CLOUD_UPGRADE_KEY, (Object)UriComponentsBuilder.fromHttpUrl((String)cloudUrlPath).path(cloudId).path("/billing/applications/change-edition/confluence.ondemand").toUriString(), (Object)USERS_MGT_SERVER_KEY, (Object)UriComponentsBuilder.fromHttpUrl((String)this.serverBaseUrl).path(USERS_PAGE_PATH).toUriString()));
        return details;
    }

    private Status getStatusByUsersCount(UsersMigrationRequest request, CloudEditionCheckResponse response) {
        Set usersWithPermissions = request.getGroups().stream().filter(group -> !group.getPermissions().isEmpty()).map(group -> request.getMembership().getOrDefault(group.getName(), Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toSet());
        long countOfUsersWhichWillHaveAccessToConfluence = request.getUsers().stream().filter(migrationUserDto -> usersWithPermissions.contains(migrationUserDto.getEmail()) && migrationUserDto.isActive()).count();
        return countOfUsersWhichWillHaveAccessToConfluence > Integer.valueOf(response.usersCount).longValue() ? Status.ERROR : Status.WARNING;
    }

    static Map<String, String> retrieveLinks(Map<String, Object> details) {
        return (Map)details.get(LINKS_KEY);
    }

    static int retrieveUsersLimit(Map<String, Object> details) {
        return (Integer)details.get(USERS_LIMIT_KEY);
    }

    public static Status retrieveStatus(Map<String, Object> details) {
        return (Status)details.get(STATUS_KEY);
    }

    private static boolean isCloudUrlInProduction(String cloudUrl) {
        return cloudUrl.endsWith("atlassian.net");
    }

    static boolean hasEditionChanged(Map<String, Object> details) {
        return (Boolean)details.getOrDefault(EDITION_CHANGED, false);
    }
}

