/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import java.util.Arrays;

public enum CheckType {
    INVALID_EMAILS("InvalidEmails"),
    SHARED_EMAILS("SharedEmails"),
    SPACES_INVALID_EMAILS("SpacesInvalidEmails"),
    SPACES_SHARED_EMAILS("SpacesSharedEmails"),
    APP_OUTDATED("AppOutdated"),
    SPACE_KEYS_CONFLICT("SpaceKeysConflict"),
    GROUP_NAMES_CONFLICT("GroupNamesConflict"),
    CLOUD_FREE_USERS_CONFLICT("CloudFreeUsersConflict");

    private final String value;

    private CheckType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static CheckType fromString(String value) {
        return Arrays.stream(CheckType.values()).filter(it -> it.value().equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Check type [%s] not found", value)));
    }
}

