/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.app;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PluginManager {
    private static final Set<String> ATLASSIAN_APP_KEYS = Sets.newHashSet((Object[])new String[]{"com.atlassian.migration.agent", "com.atlassian.plugins.base-hipchat-integration-plugin-api", "com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin", "com.atlassian.labs.rest-api-browser", "com.atlassian.support.stp", "com.atlassian.plugins.base-hipchat-integration-plugin", "com.atlassian.upm.atlassian-universal-plugin-manager-plugin", "com.atlassian.labs.hipchat.confluence-hipchat", "com.atlassian.confluence.plugins.confluence-healthcheck-plugin", "com.atlassian.support.healthcheck.support-healthcheck-plugin", "com.atlassian.troubleshooting.plugin-confluence", "com.atlassian.confluence.plugins.confluence-mobile-plugin"});
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;

    @Inject
    public PluginManager(PluginAccessor pluginAccessor, PluginMetadataManager pluginMetadataManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
    }

    public Collection<Plugin> getActualUserInstalledPlugins() {
        return this.pluginAccessor.getPlugins().parallelStream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !this.isAtlassianReserved((Plugin)plugin)).collect(Collectors.toList());
    }

    public Plugin getPlugin(String appKey) {
        return this.pluginAccessor.getPlugin(appKey);
    }

    private boolean isAtlassianReserved(Plugin plugin) {
        return ATLASSIAN_APP_KEYS.contains(plugin.getKey());
    }
}

