/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model.stats;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public final class AttachmentStats {
    public static final AttachmentStats ZERO = AttachmentStats.builder().build();
    @JsonProperty
    private final long averageSize;
    @JsonProperty
    private final long minimumSize;
    @JsonProperty
    private final long maximumSize;
    @JsonProperty
    private final long totalSize;

    @JsonCreator
    private AttachmentStats(@JsonProperty(value="averageSize") long averageSize, @JsonProperty(value="minimumSize") long minimumSize, @JsonProperty(value="maximumSize") long maximumSize, @JsonProperty(value="totalSize") long totalSize) {
        this.averageSize = averageSize;
        this.minimumSize = minimumSize;
        this.maximumSize = maximumSize;
        this.totalSize = totalSize;
    }

    public long getAverageSize() {
        return this.averageSize;
    }

    public long getMinimumSize() {
        return this.minimumSize;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long averageSize;
        private long minimumSize;
        private long maximumSize;
        private long totalSize;

        private Builder() {
        }

        @Nonnull
        public Builder averageSize(long averageSize) {
            this.averageSize = averageSize;
            return this;
        }

        @Nonnull
        public Builder minimumSize(long minimumSize) {
            this.minimumSize = minimumSize;
            return this;
        }

        @Nonnull
        public Builder maximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        @Nonnull
        public Builder totalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @Nonnull
        public AttachmentStats build() {
            return new AttachmentStats(this.averageSize, this.minimumSize, this.maximumSize, this.totalSize);
        }
    }
}

