/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.media.MediaClientTokenSupplier;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CachedMediaClientTokenSupplier
implements MediaClientTokenSupplier {
    private static final Duration DEFAULT_TOKEN_TTL = Duration.ofMinutes(8L);
    private final LoadingCache<String, MediaClientToken> clientTokens;

    @Inject
    CachedMediaClientTokenSupplier(MigrationPlatformService migrationPlatformService) {
        this(migrationPlatformService, Ticker.systemTicker());
    }

    @VisibleForTesting
    CachedMediaClientTokenSupplier(final MigrationPlatformService defaultMigrationPlaftormService, Ticker ticker) {
        this.clientTokens = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(DEFAULT_TOKEN_TTL.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, MediaClientToken>(){

            public MediaClientToken load(String containerToken) {
                return defaultMigrationPlaftormService.getMediaToken(containerToken);
            }
        });
    }

    @Override
    @Nonnull
    public MediaClientToken getToken(String containerToken) {
        try {
            return (MediaClientToken)this.clientTokens.get((Object)containerToken);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException("Failed to load media token for container token.", e);
        }
    }
}

