@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
/**
 * Package that handles the registration of {@link MessageRunner}s under keys.
 *
 * <p>
 *     Once a {@link MessageRunner} has been registered, all access to the runner is via the corresponding
 *     {@link com.atlassian.message.MessageRunnerKey}
 * </p>
 *
 * <pre>
 * {@code
 *     public static final MessageRunnerKey MESSAGE_RUNNER_KEY = MessageRunnerKey.of("export-space");
 *
 *     public ExportSpaceMessageRunnerFactory() {
 *        messageRegistryService.registerMessageRunner(MESSAGE_RUNNER_KEY, new ExportSpaceMessageRunner());
 *     }
 *
 *     private static class ExportSpaceMessageRunner() {
 *         @Override
 *         public void processMessage(MessageContext messageContext) {
 *             Optional<String> payload = messageContext.getPayload();
 *             // deserialize payload and do some message ...
 *         }
 *     }
 * }
 * </pre>
 * @since 1.0
 */
package com.atlassian.messagequeue.registry;

import com.atlassian.annotations.nonnull.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;