package com.atlassian.messagequeue.registry;

import com.atlassian.annotations.PublicApi;
import com.atlassian.messagequeue.MessageRunnerKey;

/**
 * Interface for registering and unregistering message runners.
 * @since 1.0
 */
@PublicApi
public interface MessageRunnerRegistryService {

    /**
     * Register a message runner on the given key. Registering a new runner for the same key replaces the old runner.
     * @param messageRunnerKey unique message runner key
     * @param messageRunner MessageRunner implementation
     */
    void registerMessageRunner(MessageRunnerKey messageRunnerKey, MessageRunner messageRunner);

    /**
     * Unregister a message runner that has previously been registered on the key. If no runner is registered, logs a
     * warning only.
     * @param messageRunnerKey unique message runner key
     */
    void unregisterMessageRunner(MessageRunnerKey messageRunnerKey);
}