@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
/**
 * Package that handles the invocation of registered {@link MessageRunner}s. Access to registered messages is always via
 * the registered {@link MessageRunnerKey}.
 *
 * <pre>
 * {@code
 *     private final MessageRunnerService messageRunnerService;
 *
 *     public void launchMessage() {
 *         String payload = getSomeJson().serialize();
 *
 *         messageRunnerService.addMessage(Message.builder(MyMessageRunner.MY_RUNNER_KEY)
 *             .payload(payload)
 *             .build());
 *     }
 * }
 * </pre>
 *
 * @since 1.0
 */
package com.atlassian.messagequeue;

import com.atlassian.annotations.nonnull.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;