package com.atlassian.messagequeue;

import com.atlassian.annotations.PublicApi;

/**
 * Constants for the MessageRunner system.
 * @since v1.0
 */
@PublicApi
public class MessageRunnerConstants {

    private static final int MAX_PAYLOAD_SIZE = 32 * 1024;

    /**
     * <p>
     *     Note that this is deliberately not exposed as a system property. It is determined by the max size of
     *     something that will fit in an SQS message, minus a defensible approximation how a java string is encoded
     *     to sent to SQS.
     * </p>
     * <p>
     *     This could change when SQS increases its capacity, or when we decide that the we can squeeze more out of
     *     encoding. Either of those events are rare enough that having this declared in-code is acceptable.
     * </p>
     * @return the max size of message payloads.
     */
    public static int payloadMaxSize() {
        return MAX_PAYLOAD_SIZE;
    }
}
