/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api.entity;

import com.atlassian.media.client.api.entity.ByteRange;
import com.atlassian.media.client.api.entity.SimpleByteRange;

public class ByteRanges {
    public static ByteRange simpleRange(long begin, long end) {
        return new SimpleByteRange(begin, end);
    }

    public static ByteRange lastBytes(final long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be greater than zero");
        }
        return new ByteRange(){

            @Override
            public String getSpecifier() {
                return "-" + length;
            }
        };
    }

    public static ByteRange from(final long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be greater than or equal to zero");
        }
        return new ByteRange(){

            @Override
            public String getSpecifier() {
                return offset + "-";
            }
        };
    }
}

