/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api;

import com.atlassian.fugue.Option;
import java.util.Objects;
import javax.annotation.Nullable;

public class Failure {
    private final Reason reason;
    private final String message;
    private final Integer httpStatusCode;
    private final Throwable cause;

    public Failure(Reason reason) {
        this.reason = Objects.requireNonNull(reason);
        this.cause = null;
        this.message = null;
        this.httpStatusCode = null;
    }

    public Failure(Reason reason, Throwable cause) {
        this.reason = Objects.requireNonNull(reason);
        this.cause = cause;
        this.message = null;
        this.httpStatusCode = null;
    }

    private Failure(Builder builder) {
        this.reason = Objects.requireNonNull(builder.reason);
        this.message = builder.message;
        this.cause = builder.cause;
        this.httpStatusCode = builder.httpStatusCode;
    }

    public static Builder builder(Reason reason) {
        return new Builder(Objects.requireNonNull(reason));
    }

    public Reason getReason() {
        return this.reason;
    }

    public Option<Throwable> getCause() {
        return Option.option((Object)this.cause);
    }

    public Option<String> getMessage() {
        return Option.option((Object)this.message);
    }

    public Option<Integer> getHttpStatusCode() {
        return Option.option((Object)this.httpStatusCode);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper(this.getClass()).add("reason", (Object)this.reason).add("message", (Object)this.message).add("httpStatusCode", (Object)this.httpStatusCode).add("causeSet", this.getCause().isDefined()).toString();
    }

    public static class Builder {
        private final Reason reason;
        private String message;
        private Throwable cause;
        private Integer httpStatusCode;

        private Builder(Reason reason) {
            this.reason = Objects.requireNonNull(reason);
        }

        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder httpStatusCode(int statusCode) {
            this.httpStatusCode = statusCode;
            return this;
        }

        public Failure build() {
            return new Failure(this);
        }
    }

    public static enum Reason {
        BAD_STATUS,
        TRANSPORT_ERROR,
        FILE_NOT_FOUND,
        SERIALIZATION_ERROR;

    }
}

