/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ProjectReleaseVersionChange
implements ProjectChange {
    private final Map<String, String> releaseVersions;
    private final List<String> workLog;

    private ProjectReleaseVersionChange(Map<String, String> releaseVersions) {
        this.releaseVersions = releaseVersions;
        this.workLog = new ArrayList<String>();
    }

    public static ProjectReleaseVersionChange projectReleaseVersionChange(Map<String, String> releaseVersions) {
        return new ProjectReleaseVersionChange(releaseVersions);
    }

    @Override
    public boolean applyChange(MavenProject project, Element root) throws ProjectRewriteException {
        boolean modified = false;
        Namespace ns = ProjectChangeUtils.getNamespaceOrNull(root);
        Element versionElement = root.getChild("version", ns);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        String releaseVersion = this.releaseVersions.get(projectId);
        if (Strings.isNullOrEmpty((String)releaseVersion)) {
            throw new ProjectRewriteException("Release version for " + project.getName() + " was not found");
        }
        if (null == versionElement) {
            String parentVersion = null;
            if (project.hasParent()) {
                MavenProject parent = project.getParent();
                String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                parentVersion = this.releaseVersions.get(parentId);
            }
            if (!releaseVersion.equals(parentVersion)) {
                Element artifactId = root.getChild("artifactId", ns);
                versionElement = new Element("version");
                this.workLog.add("setting version to '" + releaseVersion + "'");
                versionElement.setText(releaseVersion);
                root.getChildren().add(root.indexOf((Content)artifactId) + 1, versionElement);
                modified = true;
            }
        } else {
            this.workLog.add("updating version '" + versionElement.getTextTrim() + " to '" + releaseVersion + "'");
            versionElement.setText(releaseVersion);
            modified = true;
        }
        return modified;
    }

    public String toString() {
        if (this.workLog.isEmpty()) {
            return "[Update Project Release Version]";
        }
        return "[Update Project Release Version]\n - " + Joiner.on((String)"\n - ").join(this.workLog);
    }
}

