/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.clover.CloverInstr;
import com.atlassian.clover.Logger;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileExtensionFilter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractInstrumenter {
    private CompilerConfiguration configuration;
    String outputSourceDirectory;
    private static final String PROP_PROJECT_BUILD_SOURCEENCODING = "project.build.sourceEncoding";

    public AbstractInstrumenter(CompilerConfiguration configuration, String outputSourceDirectory) {
        this.configuration = configuration;
        this.outputSourceDirectory = outputSourceDirectory;
    }

    protected CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void instrument() throws MojoExecutionException {
        CloverSourceScanner scanner = this.getSourceScanner();
        Map<String, String[]> javaFilesToInstrument = scanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.JAVA_LANGUAGE, true);
        if (javaFilesToInstrument.isEmpty()) {
            this.getConfiguration().getLog().info((CharSequence)("No Clover instrumentation done on source files in: " + this.getCompileSourceRoots() + " as no matching sources files found (JAVA_LANGUAGE)"));
        } else {
            this.instrumentSources(javaFilesToInstrument, this.outputSourceDirectory);
        }
        Map<String, String[]> groovyFilesToInstrument = scanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, true);
        if (!groovyFilesToInstrument.isEmpty()) {
            this.copyExcludedFiles(groovyFilesToInstrument, this.outputSourceDirectory);
        }
        if (this.configuration.isCopyExcludedFiles()) {
            Map<String, String[]> explicitlyExcludedFiles = scanner.getExcludedFiles();
            this.copyExcludedFiles(explicitlyExcludedFiles, this.outputSourceDirectory);
        }
    }

    public String redirectSourceDirectories() {
        return this.redirectSourceDirectories(this.outputSourceDirectory);
    }

    protected abstract CloverSourceScanner getSourceScanner();

    protected abstract String getSourceDirectory();

    protected abstract void setSourceDirectory(String var1);

    protected abstract List<String> getCompileSourceRoots();

    protected abstract void addCompileSourceRoot(String var1);

    protected abstract boolean isGeneratedSourcesDirectory(String var1);

    private String redirectSourceDirectories(String targetDirectory) {
        String oldSourceDirectory = this.getSourceDirectory();
        if (new File(oldSourceDirectory).exists()) {
            this.setSourceDirectory(targetDirectory);
        }
        this.getConfiguration().getLog().debug((CharSequence)("Clover " + this.getSourceType() + " source directories before change:"));
        this.logSourceDirectories();
        ArrayList<String> sourceRoots = new ArrayList<String>(this.getCompileSourceRoots());
        this.getCompileSourceRoots().removeAll(sourceRoots);
        CloverSourceScanner scanner = this.getSourceScanner();
        for (String sourceRoot : sourceRoots) {
            boolean needsRedirection;
            boolean bl = needsRedirection = this.getConfiguration().isIncludesAllSourceRoots() || !this.isGeneratedSourcesDirectory(sourceRoot);
            if (scanner.isSourceRootForLanguage(sourceRoot, (Language)Language.Builtin.GROOVY)) {
                this.addCompileSourceRoot(sourceRoot);
                continue;
            }
            this.addCompileSourceRoot(needsRedirection ? this.getSourceDirectory() : sourceRoot);
        }
        this.getConfiguration().getLog().debug((CharSequence)("Clover " + this.getSourceType() + " source directories after change:"));
        this.logSourceDirectories();
        return oldSourceDirectory;
    }

    private void logSourceDirectories() {
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            for (String sourceRoot : this.getCompileSourceRoots()) {
                this.getConfiguration().getLog().debug((CharSequence)("[Clover]  source root [" + sourceRoot + "]"));
            }
        }
    }

    private void copyExcludedFiles(Map<String, String[]> excludedFiles, String targetDirectory) throws MojoExecutionException {
        for (String sourceRoot : excludedFiles.keySet()) {
            String[] filesInSourceRoot;
            for (String fileName : filesInSourceRoot = excludedFiles.get(sourceRoot)) {
                File srcFile = new File(sourceRoot, fileName);
                try {
                    this.configuration.getLog().debug((CharSequence)("Copying excluded file: " + srcFile.getAbsolutePath() + " to " + targetDirectory));
                    FileUtils.copyFile((File)srcFile, (File)new File(targetDirectory, srcFile.getPath().substring(sourceRoot.length())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy excluded file [" + srcFile + "] to [" + targetDirectory + "]", (Exception)e);
                }
            }
        }
    }

    private void instrumentSources(Map<String, String[]> filesToInstrument, String outputDir) throws MojoExecutionException {
        Logger.setInstance((Logger)new MvnLogger(this.configuration.getLog()));
        new File(outputDir).mkdirs();
        int result = CloverInstr.mainImpl((String[])this.createCliArgs(filesToInstrument, outputDir));
        if (result != 0) {
            throw new MojoExecutionException("Clover has failed to instrument the source files in the [" + outputDir + "] directory");
        }
    }

    private String[] createCliArgs(Map<String, String[]> filesToInstrument, String outputDir) throws MojoExecutionException {
        String javaLevel;
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-p");
        parameters.add(this.getConfiguration().getFlushPolicy());
        parameters.add("-f");
        parameters.add("" + this.getConfiguration().getFlushInterval());
        parameters.add("-i");
        parameters.add(this.getConfiguration().resolveCloverDatabase());
        parameters.add("-d");
        parameters.add(outputDir);
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            parameters.add("-v");
        }
        if (this.getConfiguration().getDistributedCoverage() != null && this.getConfiguration().getDistributedCoverage().isEnabled()) {
            parameters.add("--distributedCoverage");
            parameters.add(this.getConfiguration().getDistributedCoverage().toString());
        }
        if ((javaLevel = this.getConfiguration().getJdk()) != null) {
            if (javaLevel.matches("1\\.[345678]")) {
                parameters.add("--source");
                parameters.add(javaLevel);
            } else {
                throw new MojoExecutionException("Unsupported java language level version [" + javaLevel + "]. Valid values are [1.3], [1.4], [1.5], [1.6], [1.7] and [1.8]");
            }
        }
        if (!this.getConfiguration().isUseFullyQualifiedJavaLang()) {
            parameters.add("--dontFullyQualifyJavaLang");
        }
        if (this.getConfiguration().getEncoding() != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getEncoding());
        } else if (this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING) != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING).toString());
        }
        if (this.getConfiguration().getInstrumentation() != null) {
            parameters.add("--instrlevel");
            parameters.add(this.getConfiguration().getInstrumentation());
        }
        if (this.getConfiguration().getInstrumentLambda() != null) {
            parameters.add("--instrlambda");
            parameters.add(this.getConfiguration().getInstrumentLambda());
        }
        for (String srcDir : filesToInstrument.keySet()) {
            String[] filesInSourceRoot;
            for (String s : filesInSourceRoot = filesToInstrument.get(srcDir)) {
                File file = new File(srcDir, s);
                parameters.add(file.getPath());
            }
        }
        this.addCustomContexts(parameters, this.getConfiguration().getMethodContexts().entrySet(), "-mc");
        this.addCustomContexts(parameters, this.getConfiguration().getStatementContexts().entrySet(), "-sc");
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            this.getConfiguration().getLog().debug((CharSequence)"Parameter list being passed to Clover CLI:");
            for (String param : parameters) {
                this.getConfiguration().getLog().debug((CharSequence)("  parameter = [" + param + "]"));
            }
        }
        return (String[])Iterables.toArray(parameters, String.class);
    }

    private void addCustomContexts(List<String> parameters, Set<Map.Entry<String, String>> contexts, String flag) {
        for (Map.Entry<String, String> entry : contexts) {
            parameters.add(flag);
            parameters.add(entry.getKey() + "=" + entry.getValue());
        }
    }

    protected abstract String getSourceType();
}

