/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.cenqua.clover.Logger;
import com.cenqua.clover.types.CloverAlwaysRunTestSet;
import com.cenqua.clover.types.CloverOptimizedTestSet;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class CloverOptimizerMojo
extends AbstractCloverMojo {
    private int fullRunEvery;
    private List optimizeIncludes;
    private List optimizeExcludes;
    private List alwaysRunTests;
    private String ordering;
    private boolean enabled;
    private boolean minimize;
    private static final List DEFAULT_INCLUDES = Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java");

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping build optimization.");
            return;
        }
        String sourceDirectory = this.getProject().getBuild().getSourceDirectory();
        String testSourceDirectory = this.getProject().getBuild().getTestSourceDirectory();
        if (!new File(sourceDirectory).exists() && !new File(testSourceDirectory).exists()) {
            this.getLog().info((CharSequence)(sourceDirectory + " and " + testSourceDirectory + " do not exist. No optimization will be done for: " + this.getProject().getGroupId() + ":" + this.getProject().getArtifactId()));
            return;
        }
        Project antProj = new Project();
        antProj.init();
        antProj.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        List optimizedTests = this.configureOptimisedTestSet(antProj);
        StringBuffer testPattern = new StringBuffer();
        Iterator iterator = optimizedTests.iterator();
        while (iterator.hasNext()) {
            Resource test = (Resource)iterator.next();
            this.getLog().debug((CharSequence)("Running TEST: " + test.getName()));
            testPattern.append(test.getName());
            testPattern.append(",");
        }
        this.getLog().debug((CharSequence)("Setting test property to: '" + testPattern + "'"));
        this.getProject().getProperties().put("failIfNoTests", "false");
        if (optimizedTests.size() == 0) {
            this.getProject().getProperties().put("test", "clover/optimized/test/PlaceHolder.java");
        } else {
            this.getProject().getProperties().put("test", testPattern.toString());
        }
    }

    private List configureOptimisedTestSet(Project antProj) {
        List includes = this.optimizeIncludes;
        List excludes = this.optimizeExcludes;
        if (includes == null && excludes == null) {
            this.getLog().debug((CharSequence)"No clover excludes or includes specified. Falling back to Surefire configuration.");
            Plugin surefirePlugin = this.lookupSurefirePlugin();
            if (surefirePlugin != null) {
                includes = this.extractNestedStrings("includes", surefirePlugin);
                excludes = this.extractNestedStrings("excludes", surefirePlugin);
            }
            if (includes == null) {
                includes = DEFAULT_INCLUDES;
            }
        }
        this.getLog().debug((CharSequence)("Effective filtering: includes=" + includes + ", excludes=" + excludes));
        CloverOptimizedTestSet testsToRun = new CloverOptimizedTestSet();
        testsToRun.setProject(antProj);
        testsToRun.setLogger((Logger)new MvnLogger(this.getLog()));
        testsToRun.setFullRunEvery(this.fullRunEvery);
        testsToRun.setDebug(this.debug);
        testsToRun.setSnapshotFile(new ConfigUtil(this).resolveSnapshotFile(this.snapshot));
        if (this.ordering != null) {
            CloverOptimizedTestSet.TestOrdering order = new CloverOptimizedTestSet.TestOrdering();
            order.setValue(this.ordering);
            testsToRun.setOrdering(order);
        }
        testsToRun.setMinimize(this.minimize);
        testsToRun.setEnabled(this.enabled);
        antProj.setProperty("clover.initstring", this.resolveCloverDatabase());
        antProj.setName(this.getProject().getName());
        List testSources = this.getProject().getTestCompileSourceRoots();
        Iterator iterator = testSources.iterator();
        while (iterator.hasNext()) {
            this.addTestRoot(antProj, includes, excludes, testsToRun, (String)iterator.next());
        }
        return testsToRun.getOptimizedTestResource();
    }

    protected List extractNestedStrings(String elementName, Plugin surefirePlugin) {
        Xpp3Dom config = (Xpp3Dom)surefirePlugin.getConfiguration();
        return config == null ? null : this.extractNestedStrings(elementName, config);
    }

    private void addTestRoot(Project antProj, List includes, List excludes, CloverOptimizedTestSet testsToRun, String testRoot) {
        File testRootDir = new File(testRoot);
        if (!testRootDir.exists()) {
            return;
        }
        this.getLog().info((CharSequence)("Adding fileset: directory=" + testRootDir + ", includes=" + includes + ", excludes=" + excludes));
        testsToRun.add((ResourceCollection)this.createFileSet(antProj, testRootDir, includes, excludes));
        if (this.alwaysRunTests != null) {
            FileSet alwaysRunFileSet = this.createFileSet(antProj, testRootDir, this.alwaysRunTests, null);
            CloverAlwaysRunTestSet alwaysRunTestSet = new CloverAlwaysRunTestSet();
            alwaysRunTestSet.setProject(antProj);
            alwaysRunTestSet.add((ResourceCollection)alwaysRunFileSet);
            testsToRun.add(alwaysRunTestSet);
        }
    }

    private FileSet createFileSet(Project antProject, File directory, List includes, List excludes) {
        FileSet testFileSet = new FileSet();
        testFileSet.setProject(antProject);
        testFileSet.setDir(directory);
        testFileSet.appendIncludes(includes.toArray(new String[includes.size()]));
        if (excludes != null && !excludes.isEmpty()) {
            testFileSet.appendExcludes(excludes.toArray(new String[excludes.size()]));
        }
        return testFileSet;
    }

    protected List extractNestedStrings(String childname, Xpp3Dom config) {
        Xpp3Dom subelement = config.getChild(childname);
        if (subelement != null) {
            LinkedList<String> result = new LinkedList<String>();
            Xpp3Dom[] children = subelement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom child = children[i];
                result.add(child.getValue());
            }
            return result;
        }
        return null;
    }

    private Plugin lookupSurefirePlugin() {
        String key = "org.apache.maven.plugins:maven-surefire-plugin";
        MavenProject mavenProject = this.getProject();
        if (mavenProject == null) {
            this.getLog().warn((CharSequence)"Maven execution project is null. Surefire configuration will be ignored.");
            return null;
        }
        List plugins = mavenProject.getBuildPlugins();
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (!"org.apache.maven.plugins:maven-surefire-plugin".equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }
}

