/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.CloverSetupMojo;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.tasks.CloverLogTask;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class CloverLogMojo
extends AbstractCloverMojo {
    String contextFilters;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover log.");
            return;
        }
        if (this.areCloverDatabasesAvailable()) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            this.log();
        } else {
            this.getLog().info((CharSequence)"No Clover database found, skipping Clover database logging");
        }
    }

    private void log() {
        if (new File(this.resolveCloverDatabase()).exists()) {
            this.logDatabase(this.resolveCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.logDatabase(this.getCloverMergeDatabase());
        }
    }

    private void logDatabase(String database) {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        CloverLogTask cloverLogTask = (CloverLogTask)antProject.createTask("clover-log");
        cloverLogTask.init();
        cloverLogTask.setInitString(database);
        cloverLogTask.setOutputProperty("cloverlogproperty");
        if (this.contextFilters != null) {
            cloverLogTask.setFilter(this.contextFilters);
        }
        this.setTestSourceRoots(cloverLogTask);
        cloverLogTask.execute();
        this.getLog().info((CharSequence)antProject.getProperty("cloverlogproperty"));
    }

    private void setTestSourceRoots(CloverLogTask cloverLogTask) {
        this.setTestSourceRootsForProject(cloverLogTask, this.getProject());
        Iterator iterator = this.getDescendentModuleProjects(this.getProject()).iterator();
        while (iterator.hasNext()) {
            MavenProject project = (MavenProject)iterator.next();
            this.setTestSourceRootsForProject(cloverLogTask, project);
        }
    }

    private void setTestSourceRootsForProject(CloverLogTask cloverLogTask, MavenProject project) {
        String originalSrcTestDir = CloverSetupMojo.getOriginalSrcTestDir(project.getId());
        if (originalSrcTestDir != null) {
            this.addTestSrcDir(cloverLogTask, originalSrcTestDir);
        }
        List testSourceRoots = project.getTestCompileSourceRoots();
        this.addTestSrcDirs(cloverLogTask, testSourceRoots.iterator());
    }

    private void addTestSrcDirs(CloverLogTask cloverLogTask, Iterator iterator) {
        while (iterator.hasNext()) {
            String testDir = (String)iterator.next();
            this.addTestSrcDir(cloverLogTask, testDir);
        }
    }

    private void addTestSrcDir(CloverLogTask cloverLogTask, String originalSrcTestDir) {
        File dir = new File(originalSrcTestDir);
        if (dir.exists()) {
            FileSet testFiles = new FileSet();
            testFiles.setDir(dir);
            cloverLogTask.addTestSources(testFiles);
        }
    }
}

