/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal;

import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import java.io.File;
import org.apache.maven.project.MavenProject;

public class ConfigUtil {
    final CloverConfiguration config;

    public ConfigUtil(CloverConfiguration config) {
        this.config = config;
    }

    public String resolveCloverDatabase() {
        if (this.config.getCloverDatabase() != null) {
            return this.config.getCloverDatabase();
        }
        MavenProject project = this.resolveMavenProject();
        return project.getBuild().getDirectory() + "/clover/clover.db";
    }

    public MavenProject resolveMavenProject() {
        return this.config.isSingleCloverDatabase() ? (MavenProject)this.config.getReactorProjects().get(0) : this.config.getProject();
    }

    public File resolveSnapshotFile(File snapshot) {
        if (snapshot != null) {
            return snapshot;
        }
        MavenProject project = this.resolveMavenProject();
        File baseCloverDir = new File(project.getBasedir(), ".clover");
        baseCloverDir.mkdir();
        return new File(baseCloverDir, "clover.snapshot");
    }
}

