/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.scanner;

import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public abstract class AbstractCloverSourceScanner
implements CloverSourceScanner {
    private CloverConfiguration configuration;

    public AbstractCloverSourceScanner(CloverConfiguration configuration) {
        this.configuration = configuration;
    }

    protected CloverConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map getSourceFilesToInstrument() {
        return this.computeFiles(this.getScanner());
    }

    public Map getExcludedFiles() {
        return this.computeFiles(this.getExcludesScanner());
    }

    protected abstract List getSourceRoots();

    protected abstract String getSourceDirectory();

    private SourceInclusionScanner getScanner() {
        SimpleSourceInclusionScanner scanner;
        Set<String> includes = this.getConfiguration().getIncludes();
        Set excludes = this.getConfiguration().getExcludes();
        if (includes.isEmpty() && excludes.isEmpty()) {
            includes = Collections.singleton("**/*.java");
            scanner = new SimpleSourceInclusionScanner(includes, Collections.EMPTY_SET);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*.java");
            }
            scanner = new SimpleSourceInclusionScanner(includes, excludes);
        }
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("dummy", "dummy"));
        return scanner;
    }

    private SourceInclusionScanner getExcludesScanner() {
        Set excludes = this.getConfiguration().getExcludes();
        SimpleSourceInclusionScanner scanner = excludes.isEmpty() ? new SimpleSourceInclusionScanner(Collections.EMPTY_SET, Collections.EMPTY_SET) : new SimpleSourceInclusionScanner(excludes, Collections.EMPTY_SET);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("dummy", "dummy"));
        return scanner;
    }

    private Map computeFiles(SourceInclusionScanner scanner) {
        HashMap<String, Set> files = new HashMap<String, Set>();
        Iterator sourceRoots = this.getResolvedSourceRoots().iterator();
        while (sourceRoots.hasNext()) {
            File sourceRoot = new File((String)sourceRoots.next());
            if (!sourceRoot.exists()) continue;
            try {
                Set sourcesToAdd = scanner.getIncludedSources(sourceRoot, null);
                if (sourcesToAdd.isEmpty()) continue;
                files.put(sourceRoot.getPath(), sourcesToAdd);
            }
            catch (InclusionScanException e) {
                this.getConfiguration().getLog().warn((CharSequence)("Failed to add sources from [" + sourceRoot + "]"), (Throwable)e);
            }
        }
        return files;
    }

    private List getResolvedSourceRoots() {
        List<String> sourceRoots = this.getConfiguration().includesAllSourceRoots() ? this.getSourceRoots() : Collections.singletonList(this.getSourceDirectory());
        return sourceRoots;
    }
}

