/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.cenqua.clover.CloverInstr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractInstrumenter {
    private CloverConfiguration configuration;
    private String outputSourceDirectory;

    public AbstractInstrumenter(CloverConfiguration configuration, String outputSourceDirectory) {
        this.configuration = configuration;
        this.outputSourceDirectory = outputSourceDirectory;
    }

    protected CloverConfiguration getConfiguration() {
        return this.configuration;
    }

    public void instrument() throws MojoExecutionException {
        CloverSourceScanner scanner = this.getSourceScanner();
        Map filesToInstrument = scanner.getSourceFilesToInstrument();
        if (filesToInstrument.isEmpty()) {
            this.getConfiguration().getLog().warn((CharSequence)"No Clover instrumentation done on source files as no matching sources files found");
        } else {
            this.instrumentSources(filesToInstrument, this.outputSourceDirectory);
        }
        this.copyExcludedFiles(scanner.getExcludedFiles(), this.outputSourceDirectory);
    }

    public void redirectSourceDirectories() {
        this.redirectSourceDirectories(this.outputSourceDirectory);
    }

    protected abstract CloverSourceScanner getSourceScanner();

    protected abstract String getSourceDirectory();

    protected abstract void setSourceDirectory(String var1);

    protected abstract List getCompileSourceRoots();

    protected abstract void addCompileSourceRoot(String var1);

    private void redirectSourceDirectories(String targetDirectory) {
        String oldSourceDirectory = this.getSourceDirectory();
        if (new File(oldSourceDirectory).exists()) {
            this.setSourceDirectory(targetDirectory);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover source directories before change:");
        this.logSourceDirectories();
        ArrayList sourceRoots = new ArrayList(this.getCompileSourceRoots());
        this.getCompileSourceRoots().removeAll(sourceRoots);
        Iterator i = sourceRoots.iterator();
        while (i.hasNext()) {
            String sourceRoot = (String)i.next();
            if (new File(oldSourceDirectory).exists() && sourceRoot.equals(oldSourceDirectory)) {
                this.addCompileSourceRoot(this.getSourceDirectory());
                continue;
            }
            if (this.isGeneratedSourcesDirectory(sourceRoot) || this.getConfiguration().includesAllSourceRoots()) continue;
            this.addCompileSourceRoot(sourceRoot);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover main source directories after change:");
        this.logSourceDirectories();
    }

    private boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSourcesDirectoryName = File.separator + "target" + File.separator + "generated-sources";
        return sourceRoot.indexOf(generatedSourcesDirectoryName) != -1;
    }

    private void logSourceDirectories() {
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            Iterator i = this.getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                String sourceRoot = (String)i.next();
                this.getConfiguration().getLog().debug((CharSequence)("[Clover]  source root [" + sourceRoot + "]"));
            }
        }
    }

    private void copyExcludedFiles(Map excludedFiles, String targetDirectory) throws MojoExecutionException {
        Iterator sourceRoots = excludedFiles.keySet().iterator();
        while (sourceRoots.hasNext()) {
            String sourceRoot = (String)sourceRoots.next();
            Set filesInSourceRoot = (Set)excludedFiles.get(sourceRoot);
            Iterator files = filesInSourceRoot.iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                try {
                    FileUtils.copyFile((File)file, (File)new File(targetDirectory, file.getPath().substring(sourceRoot.length())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy excluded file [" + file + "] to [" + targetDirectory + "]", (Exception)e);
                }
            }
        }
    }

    private void instrumentSources(Map filesToInstrument, String outputDir) throws MojoExecutionException {
        int result = CloverInstr.mainImpl((String[])this.createCliArgs(filesToInstrument, outputDir));
        if (result != 0) {
            throw new MojoExecutionException("Clover has failed to instrument the source files in the [" + outputDir + "] directory");
        }
    }

    private String[] createCliArgs(Map filesToInstrument, String outputDir) throws MojoExecutionException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-p");
        parameters.add(this.getConfiguration().getFlushPolicy());
        parameters.add("-f");
        parameters.add("" + this.getConfiguration().getFlushInterval());
        parameters.add("-i");
        parameters.add(this.getConfiguration().getCloverDatabase());
        parameters.add("-d");
        parameters.add(outputDir);
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            parameters.add("-v");
        }
        if (this.getConfiguration().getJdk() != null) {
            if (this.getConfiguration().getJdk().equals("1.4")) {
                parameters.add("--source");
                parameters.add("1.4");
            } else if (this.getConfiguration().getJdk().equals("1.5")) {
                parameters.add("--source");
                parameters.add("1.5");
            } else if (this.getConfiguration().getJdk().equals("1.6")) {
                parameters.add("--source");
                parameters.add("1.6");
            } else {
                throw new MojoExecutionException("Unsupported jdk version [" + this.getConfiguration().getJdk() + "]. Valid values are [1.4], [1.5] and [1.6]");
            }
        }
        if (!this.getConfiguration().isUseFullyQualifiedJavaLang()) {
            parameters.add("--dontFullyQualifyJavaLang");
        }
        if (this.getConfiguration().getEncoding() != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getEncoding());
        }
        Iterator sourceRoots = filesToInstrument.keySet().iterator();
        while (sourceRoots.hasNext()) {
            Set filesInSourceRoot = (Set)filesToInstrument.get((String)sourceRoots.next());
            Iterator files = filesInSourceRoot.iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                parameters.add(file.getPath());
            }
        }
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            this.getConfiguration().getLog().debug((CharSequence)"Parameter list being passed to Clover CLI:");
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                String param = (String)it.next();
                this.getConfiguration().getLog().debug((CharSequence)("  parameter = [" + param + "]"));
            }
        }
        return parameters.toArray(new String[0]);
    }
}

