/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.codehaus.plexus.resource.ResourceManager;

public abstract class AbstractCloverMojo
extends AbstractMojo {
    private String cloverDatabase;
    private String cloverMergeDatabase;
    protected String licenseLocation;
    protected String license;
    private String flushPolicy;
    private int flushInterval;
    private boolean waitForFlush;
    private String jdk;
    private MavenProject project;
    private ResourceManager resourceManager;
    protected boolean skip;

    public void execute() throws MojoExecutionException {
        this.registerLicenseFile();
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void registerLicenseFile() throws MojoExecutionException {
        AbstractCloverMojo.registerLicenseFile(this.project, this.getResourceManager(), this.licenseLocation, this.getLog(), ((Object)((Object)this)).getClass().getClassLoader(), this.license);
    }

    public static void registerLicenseFile(MavenProject project, ResourceManager resourceManager, String licenseLocation, Log logger, ClassLoader classloader, String licenseCert) throws MojoExecutionException {
        if (licenseCert != null) {
            logger.debug((CharSequence)("Full license supplied. Length: '" + licenseCert.length() + "'. License location: '" + licenseLocation + "' will be ignored."));
            System.setProperty("clover.license.cert", licenseCert);
            return;
        }
        logger.debug((CharSequence)("Using licenseLocation '" + licenseLocation + "'"));
        boolean deleteOnExit = false;
        if (licenseLocation == null) {
            logger.info((CharSequence)"No 'maven.clover.licenseLocation' configured. Using default evaluation license.");
            licenseLocation = "/clover.license";
            deleteOnExit = true;
        }
        File licenseFile = AbstractCloverMojo.getResourceAsFile(project, resourceManager, licenseLocation, logger, classloader);
        if (deleteOnExit) {
            licenseFile.deleteOnExit();
        }
        logger.debug((CharSequence)("Using license file [" + licenseFile.getPath() + "]"));
        System.setProperty("clover.license.path", licenseFile.getPath());
    }

    public static File getResourceAsFile(MavenProject project, ResourceManager resourceManager, String resourceLocation, Log logger, ClassLoader classloader) throws MojoExecutionException {
        logger.debug((CharSequence)("Getting resource: '" + resourceLocation + "'"));
        resourceManager.addSearchPath("url", "");
        resourceManager.addSearchPath("file", project.getFile().getParentFile().getAbsolutePath());
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            try {
                File file;
                logger.debug((CharSequence)("Attempting to load resource from [" + resourceLocation + "] ..."));
                File file2 = file = resourceManager.getResourceAsFile(resourceLocation);
                return file2;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to load resource as file [" + resourceLocation + "]", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public static void registerCloverAntTasks(Project antProject, Log log) {
        antProject.addBuildListener((BuildListener)new MvnLogBuildListener(log));
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.init();
        taskdef.setResource("cloverlib.xml");
        taskdef.execute();
    }

    public static void waitForFlush(boolean waitForFlush, int flushInterval) {
        if (waitForFlush) {
            try {
                Thread.sleep(2 * flushInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean areCloverDatabasesAvailable() {
        boolean shouldRun = false;
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            shouldRun = true;
        }
        return shouldRun;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean getWaitForFlush() {
        return this.waitForFlush;
    }

    public String getJdk() {
        return this.jdk;
    }

    public String getCloverDatabase() {
        return this.cloverDatabase;
    }

    protected String getCloverMergeDatabase() {
        return this.cloverMergeDatabase;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public String getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setLicenseLocation(String licenseLocation) {
        this.licenseLocation = licenseLocation;
    }

    public void setLicense(String license) {
        this.license = license;
    }
}

