/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.tasks.CloverLogTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;

public class CloverLogMojo
extends AbstractCloverMojo {
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover log.");
            return;
        }
        if (this.areCloverDatabasesAvailable()) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            this.log();
        } else {
            this.getLog().info((CharSequence)"No Clover database found, skipping Clover database logging");
        }
    }

    private void log() {
        if (new File(this.getCloverDatabase()).exists()) {
            this.logDatabase(this.getCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.logDatabase(this.getCloverMergeDatabase());
        }
    }

    private void logDatabase(String database) {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        CloverLogTask cloverLogTask = (CloverLogTask)antProject.createTask("clover-log");
        cloverLogTask.init();
        cloverLogTask.setInitString(database);
        cloverLogTask.setOutputProperty("cloverlogproperty");
        cloverLogTask.execute();
        this.getLog().info((CharSequence)antProject.getProperty("cloverlogproperty"));
    }
}

