/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.distribution.scriptwriter;

import com.atlassian.distribution.scriptwriter.AbstractScriptWriter;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class WindowsScriptWriter
extends AbstractScriptWriter {
    public WindowsScriptWriter(File directory, String filename, boolean withTests) {
        super(directory, filename, withTests);
        this.newLine = "\r\n";
        this.extraCli = " %* ";
        this.preliminaryLines.add("@echo off");
    }

    @Override
    public void addSettingsLine(String settingsFilename) {
        this.preliminaryLines.add("set SETTINGSFILE=" + settingsFilename);
        this.addToMavenCommands("-s %SETTINGSFILE%");
    }

    @Override
    public void addLocalRepoLine(String localRepoFilename) {
        this.preliminaryLines.add("set LOCALREPO=" + localRepoFilename);
        this.addToMavenCommands("-Dmaven.repo.local=%cd%\\%LOCALREPO%");
    }

    @Override
    public void addCurrentDirToPath() {
        this.preliminaryLines.add("set PATH=%cd%;%PATH%");
    }

    @Override
    public void useErrorMode() {
        this.betweenEachCommand = "if %errorlevel% neq 0 exit /b %errorlevel%";
    }

    @Override
    public void addOtherPreliminaryLine(String line) {
        this.preliminaryLines.add(line);
    }

    @Override
    public void addCommand(String command, boolean isMaven, boolean takesExtraCli) {
        this.addCommand(command, "", isMaven, takesExtraCli);
    }

    @Override
    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli) {
        String cmd = command;
        if (!StringUtils.isBlank((String)arguments)) {
            cmd = cmd + " " + arguments;
        }
        if (isMaven) {
            cmd = cmd + this.appendToMavenCommands;
        }
        if (takesExtraCli) {
            cmd = cmd + this.extraCli;
        }
        cmd = "call " + cmd;
        this.commands.add(cmd);
    }
}

