/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sourcerelease.mojos;

import com.atlassian.maven.plugins.scm.ScmInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class SourceMojo
extends AbstractMojo {
    private ArtifactMetadataSource metadataSource;
    private MavenProjectBuilder projectBuilder;
    private ArtifactResolver resolver;
    private ScmManager manager;
    private Settings settings;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProject project;
    private File outputDirectory;
    private boolean generatePom;
    private String groupId;
    private String artifactId;
    private String version;
    private String productName;
    private String checkoutDirectoryName;
    private String groupIdMask;
    private List exclusions;
    private boolean skip;
    private List reactorProjects;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping source distribution execution");
            return;
        }
        File checkoutDirectory = this.createCheckoutDirectory();
        Set projects = this.getProjectsForArtifacts(this.getReactorProjectDependencies());
        if (projects == null) {
            throw new MojoExecutionException("Could not resolve dependent projects");
        }
        this.removeExcludedArtifacts(projects);
        MavenProject rootReactorProject = (MavenProject)this.reactorProjects.get(0);
        projects.add(rootReactorProject);
        this.getLog().info((CharSequence)("Root reactor project is " + rootReactorProject.getGroupId() + ":" + rootReactorProject.getArtifactId()));
        List modules = this.checkoutProjects(projects, checkoutDirectory);
        if (this.generatePom && modules.size() != 0) {
            this.writeSourceDistributionPom(modules, checkoutDirectory);
        }
    }

    private Set getReactorProjectDependencies() throws MojoExecutionException {
        HashSet dependencies = new HashSet();
        Iterator it = this.reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject mavenProject = (MavenProject)it.next();
            Set projectDependencies = mavenProject.getDependencyArtifacts();
            dependencies.addAll(projectDependencies);
        }
        return this.resolveTransitiveArtifacts(dependencies);
    }

    private Set getProjectsForArtifacts(Set artifacts) throws MojoExecutionException {
        HashSet<MavenProject> projects = new HashSet<MavenProject>();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            MavenProject currentProject = this.getProjectForArtifact(artifact);
            if (!artifact.getGroupId().startsWith(this.groupIdMask)) continue;
            projects.add(currentProject);
        }
        return projects;
    }

    private void removeExcludedArtifacts(Set projects) throws MojoExecutionException {
        List exclusionPairs = this.getExclusions();
        ArrayList projectList = new ArrayList(projects);
        Iterator iter = projectList.iterator();
        while (iter.hasNext()) {
            MavenProject currentProject = (MavenProject)iter.next();
            if (currentProject == null) {
                this.getLog().info((CharSequence)"Project in project list is null");
                return;
            }
            if (!this.matchesExclusion(currentProject, exclusionPairs)) continue;
            projects.remove(currentProject);
        }
    }

    private List getExclusions() {
        ArrayList<String> excludes = new ArrayList<String>(this.exclusions);
        List reactorExclusions = this.reactorProjects.subList(1, this.reactorProjects.size());
        Iterator it = reactorExclusions.iterator();
        while (it.hasNext()) {
            MavenProject mavenProject = (MavenProject)it.next();
            excludes.add(mavenProject.getGroupId() + ":" + mavenProject.getArtifactId());
        }
        return excludes;
    }

    private boolean matchesExclusion(MavenProject project, List exclusionPairs) throws MojoExecutionException {
        Iterator it = exclusionPairs.iterator();
        while (it.hasNext()) {
            String exclusion = (String)it.next();
            String[] parts = StringUtils.split((String)exclusion, (char)':');
            if (parts.length == 2) {
                String currentGroupId = project.getGroupId();
                String currentArtifactId = project.getArtifactId();
                if (!parts[0].equals(currentGroupId) || !parts[1].equals(currentArtifactId)) continue;
                return true;
            }
            throw new MojoExecutionException("Exclusion is not in the format of groupId:artifactId. Value:" + exclusion);
        }
        return false;
    }

    private List checkoutProjects(Set projects, File checkoutDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Will checkout the following artifacts:");
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            MavenProject currentProject = (MavenProject)iter.next();
            this.getLog().info((CharSequence)(currentProject.getGroupId() + ":" + currentProject.getArtifactId()));
        }
        ArrayList<String> modules = new ArrayList<String>();
        Iterator iter2 = projects.iterator();
        while (iter2.hasNext()) {
            MavenProject currentProject = (MavenProject)iter2.next();
            this.doCheckout(currentProject, checkoutDirectory);
            if (!this.generatePom) continue;
            String projectArtifactId = currentProject.getArtifactId();
            if (modules.contains(projectArtifactId)) {
                throw new MojoExecutionException("Cannot have two modules checked out with the same directory name " + projectArtifactId);
            }
            modules.add(currentProject.getArtifactId());
        }
        return modules;
    }

    private void writeSourceDistributionPom(List modules, File checkoutDirectory) throws MojoExecutionException {
        Exception ex = null;
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setName(this.productName + " Source Release");
        model.setPackaging("pom");
        model.setDescription("Source for " + this.productName);
        model.setModules(modules);
        try {
            FileWriter writer = new FileWriter(new File(checkoutDirectory, "pom.xml"));
            new MavenXpp3Writer().write((Writer)writer, model);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write source release pom", ex);
        }
    }

    private void doCheckout(MavenProject project, File checkoutDirectory) throws MojoExecutionException {
        Scm scm = project.getScm();
        if (scm != null && scm.getConnection() != null) {
            ExportScmResult result = null;
            scm.getConnection();
            ScmRepository scmRepository = null;
            try {
                scmRepository = this.getScmRepository(scm.getConnection());
                this.getLog().info((CharSequence)("Checking out " + project.getGroupId() + ":" + project.getArtifactId()));
                result = this.getScmManager().export(scmRepository, new ScmFileSet(checkoutDirectory), project.getArtifactId());
                this.checkResult((ScmResult)result);
            }
            catch (ScmException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        } else {
            this.getLog().warn((CharSequence)("Skipping " + project.getArtifactId() + " as it did not have a valid <scm> tag"));
        }
    }

    private MavenProject getProjectForArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            return this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (InvalidProjectModelException e) {
            return null;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set resolveTransitiveArtifacts(Set artifacts) throws MojoExecutionException {
        try {
            ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.metadataSource, null);
            return result.getArtifacts();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed. " + StringUtils.defaultString((String)result.getProviderMessage()));
        }
    }

    private File createCheckoutDirectory() throws MojoExecutionException {
        String dirName = this.checkoutDirectoryName;
        File checkoutDirectory = new File(this.outputDirectory, dirName);
        if (!checkoutDirectory.exists() && !checkoutDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + checkoutDirectory.getAbsolutePath());
        }
        return checkoutDirectory;
    }

    private ScmManager getScmManager() {
        return this.manager;
    }

    private ScmRepository getScmRepository(String connectionUrl) throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(connectionUrl);
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                ScmInfo info = this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)info.getUsername())) {
                    repo.setUser(info.getUsername());
                }
                if (!StringUtils.isEmpty((String)info.getPassword())) {
                    repo.setPassword(info.getPassword());
                }
                if (!StringUtils.isEmpty((String)info.getPrivateKey())) {
                    repo.setPrivateKey(info.getPrivateKey());
                }
                if (!StringUtils.isEmpty((String)info.getPassphrase())) {
                    repo.setPassphrase(info.getPassphrase());
                }
            }
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                Iterator i = e.getValidationMessages().iterator();
                while (i.hasNext()) {
                    String message = (String)i.next();
                    this.getLog().error((CharSequence)message);
                }
            }
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private ScmInfo loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        Server server;
        ScmInfo info = new ScmInfo();
        String host = repo.getHost();
        int port = repo.getPort();
        if (port > 0) {
            host = host + ":" + port;
        }
        if ((server = this.settings.getServer(host)) != null) {
            info.setUsername(this.settings.getServer(host).getUsername());
            info.setPassword(this.settings.getServer(host).getPassword());
            info.setPrivateKey(this.settings.getServer(host).getPrivateKey());
            info.setPassphrase(this.settings.getServer(host).getPassphrase());
        }
        return info;
    }
}

