/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GenerateBuildUtilsMojo
extends AbstractMojo {
    private static String BUILD_NUMBER_TOKEN = "@BUILD_NUMBER@";
    private static String VERSION_NUMBER_TOKEN = "@VERSION@";
    private static String BUILD_DATE_TOKEN = "@BUILD_DATE@";
    private static String DATE_FORMAT_TOKEN = "@DATE_FORMAT@";
    private static String PRODUCT_EDITION_TOKEN = "@EDITION@";
    private static String BUILD_PARTNER_TOKEN = "@PARTNER@";
    private MavenProject project;
    private File basedir;
    private File outputDirectory;
    private String buildNumber;
    private String buildPartner;
    private String productEdition;
    private String productVersion;
    private String dateFormat;
    private String templatePath;
    private String generatedPackage;

    public void execute() throws MojoExecutionException {
        try {
            Date buildDate = new Date();
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            String buildDateAsString = df.format(buildDate);
            FileReader r = new FileReader(new File(this.basedir, this.templatePath));
            BufferedReader br = new BufferedReader(r);
            File buildUtilsDirectory = new File(this.outputDirectory, "buildutils");
            File buildUtilsPackagePath = new File(buildUtilsDirectory, this.generatedPackage.replace('.', File.separatorChar));
            buildUtilsPackagePath.mkdirs();
            File generatedFile = new File(buildUtilsPackagePath, "BuildUtils.java");
            FileWriter wr = new FileWriter(generatedFile);
            BufferedWriter bwr = new BufferedWriter(wr);
            String line = null;
            while ((line = br.readLine()) != null) {
                line = line.replaceAll(BUILD_NUMBER_TOKEN, this.buildNumber);
                line = line.replaceAll(VERSION_NUMBER_TOKEN, this.productVersion);
                line = line.replaceAll(BUILD_DATE_TOKEN, buildDateAsString);
                line = line.replaceAll(DATE_FORMAT_TOKEN, this.dateFormat);
                line = line.replaceAll(PRODUCT_EDITION_TOKEN, this.productEdition);
                line = line.replaceAll(BUILD_PARTNER_TOKEN, this.buildPartner);
                bwr.write(line);
                bwr.newLine();
            }
            br.close();
            bwr.flush();
            bwr.close();
            this.project.addCompileSourceRoot(buildUtilsDirectory.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }
}

