package com.atlassian.maven.plugins;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Generates the BuildUtils.java file for a build
 *
 * @goal generate-buildutils
 * 
 * @phase generate-sources
 */
public class GenerateBuildUtilsMojo
    extends AbstractMojo
{
    private static String BUILD_NUMBER_TOKEN = "@BUILD_NUMBER@";
    private static String VERSION_NUMBER_TOKEN = "@VERSION@";
    private static String BUILD_DATE_TOKEN = "@BUILD_DATE@";
    private static String DATE_FORMAT_TOKEN = "@DATE_FORMAT@";
    private static String PRODUCT_EDITION_TOKEN = "@EDITION@";
    private static String BUILD_PARTNER_TOKEN = "@PARTNER@";

    /**
    * @parameter expression="${project}"
    * @required
    * @readonly
    */
    private MavenProject project;
    
    /**
     * @parameter expression="${project.basedir}"
     * @required
     * @readonly
     */
    private File basedir;

    /**
    * Location of the file.
    * @parameter expression="${project.build.directory}"
    * @required
    */
    private File outputDirectory;

    /**
    * Build Number
    * @parameter
    * @required
    */
    private String buildNumber;

    /**
    * Build Partner code
    * @parameter
    */
    private String buildPartner;

    /**
    * Product Edition
    * @parameter
    */
    private String productEdition;

    /**
    * Product Version
    * @parameter
    * @required
    */
    private String productVersion;

    /**
    * Dateformat
    * @parameter default-value "dd-MM-yyyy"
    */
    private String dateFormat;

    /**
    * Path to template
    * @parameter
    * @required
    */
    private String templatePath;

    /**
    * JAVA Package where the code will be generated. ie com.atlassian.supersecret.cool
    * @parameter
    * @required
    */
    private String generatedPackage;

    public void execute()
        throws MojoExecutionException
    {
        try
        {
            Date buildDate = new Date();
            SimpleDateFormat df = new SimpleDateFormat(dateFormat);
            String buildDateAsString = df.format(buildDate);

            FileReader r = new FileReader(new File(basedir, templatePath));
            BufferedReader br = new BufferedReader(r);

            File buildUtilsDirectory = new File(outputDirectory, "buildutils");

            File buildUtilsPackagePath = new File(buildUtilsDirectory, generatedPackage.replace('.', File.separatorChar));
            buildUtilsPackagePath.mkdirs();

            File generatedFile = new File(buildUtilsPackagePath, "BuildUtils.java");

            FileWriter wr = new FileWriter(generatedFile);
            BufferedWriter bwr = new BufferedWriter(wr);

            String line = null;
            while ((line = br.readLine()) != null)
            {
                line = line.replaceAll(BUILD_NUMBER_TOKEN, buildNumber);
                line = line.replaceAll(VERSION_NUMBER_TOKEN, productVersion);
                line = line.replaceAll(BUILD_DATE_TOKEN, buildDateAsString);
                line = line.replaceAll(DATE_FORMAT_TOKEN, dateFormat);
                line = line.replaceAll(PRODUCT_EDITION_TOKEN, productEdition);
                line = line.replaceAll(BUILD_PARTNER_TOKEN, buildPartner);

                bwr.write(line);
                bwr.newLine();
            }

            br.close();
            bwr.flush();
            bwr.close();

            this.project.addCompileSourceRoot(buildUtilsDirectory.getAbsolutePath());
        }
        catch (Exception ex)
        {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }
}
