/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.AmpsCreatePluginPrompter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create", requiresProject=false)
public class CreateMojo
extends AbstractProductHandlerMojo {
    @Component
    private AmpsCreatePluginPrompter ampsCreatePluginPrompter;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Create Plugin");
        String pid = this.getProductId();
        Product ctx = this.getProductContexts().get(pid);
        AbstractProductHandler handler = this.createProductHandler(pid);
        this.getLog().info((CharSequence)"determining latest stable product version...");
        String stableVersion = this.getStableProductVersion(handler, ctx);
        if (StringUtils.isNotBlank((String)stableVersion)) {
            this.getLog().info((CharSequence)("using latest stable product version: " + stableVersion));
            this.getMavenContext().getExecutionEnvironment().getMavenSession().getExecutionProperties().setProperty(pid + "Version", stableVersion);
        }
        this.getLog().info((CharSequence)"determining latest stable data version...");
        String stableDataVersion = this.getStableDataVersion(handler, ctx);
        if (StringUtils.isNotBlank((String)stableDataVersion)) {
            this.getLog().info((CharSequence)("using latest stable data version: " + stableDataVersion));
            this.getMavenContext().getExecutionEnvironment().getMavenSession().getExecutionProperties().setProperty(pid + "DataVersion", stableDataVersion);
        }
        this.getMavenGoals().createPlugin(this.getProductId(), this.ampsCreatePluginPrompter);
    }

    protected String getStableProductVersion(AbstractProductHandler handler, Product ctx) throws MojoExecutionException {
        ProductArtifact artifact = handler.getArtifact();
        if (null == artifact) {
            return "";
        }
        Artifact warArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), "LATEST");
        return ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
    }

    protected String getStableDataVersion(AbstractProductHandler handler, Product ctx) throws MojoExecutionException {
        ProductArtifact artifact = handler.getTestResourcesArtifact();
        if (null == artifact) {
            return "";
        }
        Artifact warArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), "LATEST");
        return ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
    }

    @Override
    protected AbstractProductHandler createProductHandler(String productId) {
        return (AbstractProductHandler)ProductHandlerFactory.create(productId, this.getMavenContext(), this.getMavenGoals(), this.artifactFactory);
    }
}

