/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.plugins.codegen.util.PluginXmlHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class AtlassianPluginContentValidator {
    private final List<String> forbiddenElements = ImmutableList.of((Object)"component-import", (Object)"component", (Object)"module-type");

    public void validate(File pluginXml) throws MojoFailureException {
        try {
            PluginXmlHelper xmlHelper = new PluginXmlHelper(pluginXml);
            Document document = xmlHelper.getDocument();
            for (String forbidden : this.forbiddenElements) {
                if (document.getRootElement().elements(forbidden).isEmpty()) continue;
                throw new MojoFailureException("\n\natlassian-plugin.xml contains a definition of " + forbidden + ". This is not allowed when Atlassian-Plugin-Key is set.\n\n" + "Please check the documentation of https://bitbucket.org/atlassian/atlassian-spring-scanner" + " or https://developer.atlassian.com/display/DOCS/Configuration+of+Instructions+in+Atlassian+Plugins for further details.\n\n");
            }
        }
        catch (IOException | DocumentException e) {
            throw new MojoFailureException("unable to read atlassian-plugin.xml, " + e);
        }
    }
}

