/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.UpdateChecker;
import com.atlassian.maven.plugins.updater.LocalSdk;
import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.Preferences;
import jline.ANSIBuffer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class UpdateCheckerImpl
extends AbstractLogEnabled
implements UpdateChecker {
    private static final String INSTALLTYPE_FILE_NAME = "installtype.txt";
    private static final String PREF_NAME = "last_update_check";
    private SdkResource sdkResource;
    private Prompter prompter;
    private LocalSdk localSdk;
    private String currentVersion;
    private boolean forceCheck;
    private boolean skipCheck;
    private boolean useAnsiColor;

    public UpdateCheckerImpl() {
        String mavencolor = System.getenv("MAVEN_COLOR");
        this.useAnsiColor = mavencolor != null && !mavencolor.equals("") ? Boolean.parseBoolean(mavencolor) : false;
        this.currentVersion = "";
        this.forceCheck = false;
        this.skipCheck = false;
    }

    @Override
    public void check() {
        block6: {
            if (this.shouldCheck()) {
                SdkPackageType packageType = this.localSdk.sdkPackageType();
                String latestVersion = this.sdkResource.getLatestSdkVersion(packageType);
                if (this.canUpdate(this.currentVersion, latestVersion)) {
                    try {
                        if (this.useAnsiColor) {
                            this.promptAnsi(latestVersion);
                            break block6;
                        }
                        this.promptPlain(latestVersion);
                    }
                    catch (PrompterException e) {
                        this.getLogger().error("error prompting for update: " + e.getMessage());
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Current version ").append(this.currentVersion);
                    sb.append(" is more recent than MPAC version ").append(latestVersion);
                    sb.append(". No action taken.");
                    this.getLogger().debug(sb.toString());
                }
            }
        }
    }

    private void promptPlain(String latestVersion) throws PrompterException {
        StringBuilder sb = new StringBuilder();
        sb.append("************************************************************").append("Version " + latestVersion + " of the Atlassian Plugin SDK is now available.\n").append("Run the atlas-update command to update.\n").append("************************************************************");
        this.getLogger().warn(sb.toString());
    }

    private void promptAnsi(String latestVersion) throws PrompterException {
        ANSIBuffer ansiBuffer = new ANSIBuffer();
        ansiBuffer.append(ANSIBuffer.ANSICodes.attrib((int)33)).append("************************************************************").append("\nVersion " + latestVersion + " of the Atlassian Plugin SDK is now available.\n").append("Run the atlas-update command to update.\n").append("************************************************************").append(ANSIBuffer.ANSICodes.attrib((int)0));
        this.getLogger().warn(ansiBuffer.toString());
    }

    private boolean canUpdate(String currentVersion, String latestVersion) {
        DefaultArtifactVersion sdkVersion = new DefaultArtifactVersion(currentVersion);
        DefaultArtifactVersion mpacVersion = new DefaultArtifactVersion(latestVersion);
        return sdkVersion.compareTo((ArtifactVersion)mpacVersion) < 0;
    }

    private boolean shouldCheck() {
        Date date;
        if (this.skipCheck) {
            return false;
        }
        if (this.forceCheck) {
            this.getLogger().warn("SDK update check forced by Maven property.");
            return true;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String lastUpdateCheck = prefs.get(PREF_NAME, null);
        if (lastUpdateCheck == null) {
            prefs.put(PREF_NAME, dateFormat.format(now.getTime()));
            return true;
        }
        try {
            date = dateFormat.parse(lastUpdateCheck);
        }
        catch (ParseException pe) {
            this.getLogger().warn("Couldn't parse date value " + lastUpdateCheck + " from prefs; deleting");
            prefs.remove(PREF_NAME);
            prefs.put(PREF_NAME, dateFormat.format(now.getTime()));
            return true;
        }
        Calendar then = Calendar.getInstance();
        then.setTime(date);
        this.getLogger().debug("Last update check: " + then.getTime());
        then.roll(5, true);
        if (then.before(now)) {
            this.getLogger().debug("Time for daily update check");
            prefs.put(PREF_NAME, dateFormat.format(now.getTime()));
            return true;
        }
        this.getLogger().debug("Already checked today");
        return false;
    }

    @Override
    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public void setForceCheck(boolean forceCheck) {
        this.forceCheck = forceCheck;
    }

    @Override
    public void setSkipCheck(boolean skipCheck) {
        this.skipCheck = skipCheck;
    }
}

