/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.AmpsEmailSubscriber;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.ANSIBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class AmpsEmailSubscriberImpl
extends AbstractLogEnabled
implements AmpsEmailSubscriber {
    private static final String EMAIL_SUBSCRIBE_ROOT = "https://hamlet.atlassian.com/1.0/public/email/";
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 15000;
    public static final List<String> YN_ANSWERS = new ArrayList<String>(Arrays.asList("Y", "y", "N", "n"));
    private boolean useAnsiColor;
    private Prompter prompter;

    public AmpsEmailSubscriberImpl() {
        String mavencolor = System.getenv("MAVEN_COLOR");
        this.useAnsiColor = mavencolor != null && !mavencolor.equals("") ? Boolean.parseBoolean(mavencolor) : false;
    }

    @Override
    public void promptForSubscription() {
        try {
            if (this.useAnsiColor) {
                this.promptForEmailAnsi();
            } else {
                this.promptForEmailPlain();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void promptForEmailPlain() throws PrompterException, IOException {
        String email;
        StringBuilder builder = new StringBuilder();
        builder.append("Would you like to subscribe to the Atlassian developer mailing list?");
        boolean signUp = this.promptForBoolean(builder.toString(), "Y");
        if (signUp && StringUtils.isNotBlank((String)(email = this.prompter.prompt("Please enter your email address (leave blank to cancel):"))) && EmailValidator.getInstance().isValid(email)) {
            this.doSubscribe(email);
        }
    }

    private void promptForEmailAnsi() throws PrompterException, IOException {
        ANSIBuffer ansiBuffer = new ANSIBuffer();
        ansiBuffer.append(ANSIBuffer.ANSICodes.attrib((int)33)).append("Would you like to subscribe to the Atlassian developer mailing list?").append(ANSIBuffer.ANSICodes.attrib((int)0));
        boolean signUp = this.promptForBoolean(ansiBuffer.toString(), "Y");
        if (signUp) {
            ANSIBuffer ansiEmailBuffer = new ANSIBuffer();
            ansiEmailBuffer.append(ANSIBuffer.ANSICodes.attrib((int)32)).append("Please enter your email address (leave blank to cancel):").append(ANSIBuffer.ANSICodes.attrib((int)0));
            String email = this.prompter.prompt(ansiEmailBuffer.toString());
            if (StringUtils.isNotBlank((String)email) && EmailValidator.getInstance().isValid(email)) {
                this.doSubscribe(email);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSubscribe(String email) throws IOException, PrompterException {
        String list = "1243499";
        String subscribeUrl = EMAIL_SUBSCRIBE_ROOT + email + "/subscribe?mailingListId=" + list;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(subscribeUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            int responseCode = conn.getResponseCode();
            if (200 != responseCode) {
                this.getLogger().error("There was an error subscribing to the email list. Perhaps you're already on it?");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Your subscription request has been sent.\n").append("Check your email for a confirmation (takes about 5 minutes) and click the opt-in link to complete the subscription process.\n").append("Press ENTER to continue");
                this.prompter.prompt(sb.toString());
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private boolean promptForBoolean(String message, String defaultValue) throws PrompterException {
        String answer = StringUtils.isBlank((String)defaultValue) ? this.prompter.prompt(message, YN_ANSWERS) : this.prompter.prompt(message, YN_ANSWERS, defaultValue);
        boolean bool = "y".equals(answer.toLowerCase());
        return bool;
    }
}

