/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMssqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMysqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracleImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabasePostgresImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import org.apache.maven.plugin.MojoExecutionException;

public final class JiraDatabaseFactory {
    private static JiraDatabaseFactory instance = null;

    private JiraDatabaseFactory() {
    }

    public static synchronized JiraDatabaseFactory getJiraDatabaseFactory() {
        if (null == instance) {
            instance = new JiraDatabaseFactory();
        }
        return instance;
    }

    public JiraDatabase getJiraDatabase(DataSource dataSource) throws MojoExecutionException {
        AbstractJiraDatabase jiraDatabase;
        JiraDatabaseType databaseType = JiraDatabaseType.getDatabaseType(dataSource.getUrl(), dataSource.getDriver());
        if (null == databaseType) {
            return null;
        }
        switch (databaseType) {
            case POSTGRES: {
                jiraDatabase = new JiraDatabasePostgresImpl(dataSource);
                break;
            }
            case MYSQL: {
                jiraDatabase = new JiraDatabaseMysqlImpl(dataSource);
                break;
            }
            case ORACLE: {
                jiraDatabase = new JiraDatabaseOracleImpl(dataSource);
                break;
            }
            case MSSQL: 
            case MSSQL_JTDS: {
                jiraDatabase = new JiraDatabaseMssqlImpl(dataSource);
                break;
            }
            default: {
                jiraDatabase = null;
            }
        }
        return jiraDatabase;
    }
}

