/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="run-standalone", requiresProject=false)
public class RunStandaloneMojo
extends AbstractProductHandlerMojo {
    private final String GROUP_ID = "com.atlassian.amps";
    private final String ARTIFACT_ID = "standalone";
    @Component
    private ProjectBuilder projectBuilder;

    private Artifact getStandaloneArtifact() {
        String version = this.getPluginInformation().getVersion();
        return this.artifactFactory.createProjectArtifact("com.atlassian.amps", "standalone", version);
    }

    protected String getAmpsGoal() {
        return "run";
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getUpdateChecker().check();
        this.promptForEmailSubscriptionIfNeeded();
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Run Standalone");
        try {
            MavenGoals goals = this.createMavenGoals(this.projectBuilder);
            PluginManagement mgmt = goals.getContextProject().getBuild().getPluginManagement();
            Plugin plugin = (Plugin)mgmt.getPluginsAsMap().get("com.atlassian.maven.plugins:maven-amps-plugin");
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            goals.executeAmpsRecursively(this.getPluginInformation().getVersion(), this.getAmpsGoal(), configuration);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected MavenGoals createMavenGoals(ProjectBuilder projectBuilder) throws MojoExecutionException, MojoFailureException, ProjectBuildingException, IOException {
        MavenContext oldContext = this.getMavenContext();
        MavenSession oldSession = oldContext.getSession();
        File base = new File("amps-standalone").getAbsoluteFile();
        ProjectBuildingRequest pbr = oldSession.getProjectBuildingRequest();
        pbr.setRemoteRepositories(oldSession.getCurrentProject().getRemoteArtifactRepositories());
        pbr.setPluginArtifactRepositories(oldSession.getCurrentProject().getPluginArtifactRepositories());
        pbr.getSystemProperties().setProperty("project.basedir", base.getPath());
        ProjectBuildingResult result = projectBuilder.build(this.getStandaloneArtifact(), false, pbr);
        List<MavenProject> newReactor = Collections.singletonList(result.getProject());
        MavenSession newSession = oldSession.clone();
        newSession.setProjects(newReactor);
        result.getProject().setFile(new DefaultModelLocator().locatePom(base));
        MavenContext newContext = oldContext.with(result.getProject(), newReactor, newSession);
        return new MavenGoals(newContext);
    }
}

