/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-home-zip")
public class CreateHomeZipMojo
extends AbstractProductHandlerMojo {
    @Parameter(property="homeZip", required=false)
    protected File homeZip;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.trackFirstRunIfNeeded();
        Product product = this.getProduct(this.instanceId, this.getProductId());
        ProductHandler productHandler = this.createProductHandler(product.getId());
        if ("studio".equals(product.getId())) {
            this.configureStudio(product, (StudioProductHandler)productHandler);
        }
        File snapshotDir = productHandler.getSnapshotDirectory(product);
        if (this.homeZip == null) {
            this.homeZip = new File(productHandler.getBaseDirectory(product), "generated-test-resources.zip");
        }
        productHandler.createHomeZip(snapshotDir, this.homeZip, product);
        this.getLog().info((CharSequence)("Home directory zip created successfully at " + this.homeZip.getAbsolutePath()));
        this.getMavenGoals().attachArtifact(this.homeZip, "zip");
    }

    private void configureStudio(Product studioProduct, StudioProductHandler studioProductHandler) throws MojoExecutionException {
        ArrayList executions = Lists.newArrayList((Object[])new ProductExecution[]{new ProductExecution(studioProduct, studioProductHandler)});
        this.includeStudioDependentProducts(executions, this.getMavenGoals());
    }

    private Product getProduct(String instanceId, String productId) throws MojoExecutionException {
        Map<String, Product> contexts = this.getProductContexts();
        Product product = null;
        if (instanceId != null) {
            product = contexts.get(instanceId);
            if (product == null) {
                throw new MojoExecutionException("There is no instance with name " + instanceId + " defined in the pom.xml");
            }
        } else {
            for (Product candidate : contexts.values()) {
                if (!candidate.getId().equals(productId)) continue;
                product = candidate;
                break;
            }
            if (product == null) {
                throw new MojoExecutionException("There is no product with name " + productId + " defined in the pom.xml. Please use -DinstanceId=..." + " to set the instance to snapshot.");
            }
        }
        return product;
    }
}

